<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-19 16:12:57
 */
namespace Mainto\Bridge\Invokes\Test\Example;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Rpc
 * @method remoteNotFoundByParams(array $params) 服务不存在
 * @method rcpLogPushByParams(array $params) 日志推送
 * @method remoteCallTestByParams(array $params) 远程调用示例
 * @method remoteCallTestWithObjectByParams(array $params) 远程调用示例,通过object调用
 */
class Rpc {
    private static string $serviceName = "Test";

    private static string $className = "Example\\Rpc";

    /**
     * 服务不存在
     * @return  mixed
    */
    public static function remoteNotFound () {
        return RpcClass::getClass(self::$serviceName, self::$className)->remoteNotFound();
    }

    /**
     * 日志推送
     * @return  array
    */
    public static function rcpLogPush () {
        return RpcClass::getClass(self::$serviceName, self::$className)->rcpLogPush();
    }

    /**
     * 远程调用示例
     * @return  int
    */
    public static function remoteCallTest () {
        return RpcClass::getClass(self::$serviceName, self::$className)->remoteCallTest();
    }

    /**
     * 远程调用示例,通过object调用
     * @return  array
    */
    public static function remoteCallTestWithObject () {
        return RpcClass::getClass(self::$serviceName, self::$className)->remoteCallTestWithObject();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}