<?php
namespace Mainto\Bridge\Invokes\Test;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryAlipayBillsByParams(array $params)
 * @method queryWechatBillsByParams(array $params)
 * @method queryPayMaxBillsByParams(array $params)
 * @method queryOrdersByParams(array $params)
 * @method billCheckByParams(array $params)
 * @method batchReloadDeferOrdersByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 支付宝账单拉取
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryAlipayBills () {
        return self::getClass()->queryAlipayBills();
    }

    /**
     * 微信账单拉取
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryWechatBills () {
        return self::getClass()->queryWechatBills();
    }

    /**
     * 拉卡拉账单拉取
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryPayMaxBills () {
        return self::getClass()->queryPayMaxBills();
    }

    /**
     * 订单拉取
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryOrders () {
        return self::getClass()->queryOrders();
    }

    /**
     * 账单校对
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function billCheck () {
        return self::getClass()->billCheck();
    }

    /**
     * 更新延迟处理订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchReloadDeferOrders () {
        return self::getClass()->batchReloadDeferOrders();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Test', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}