<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-09-19 15:11:47
 */
namespace Mainto\Bridge\Invokes\Test;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class MvcTest
 * @method messageListByParams(array $params) 获取消息列表
 * @method getMessageDetailByParams(array $params) 获取消息详情
 * @method addMessageByParams(array $params) 添加消息
 * @method updateMessageByParams(array $params) 更新消息
 * @method deleteMessageByParams(array $params) 删除消息
 * @method getServerTimeByParams(array $params) 获取服务器时间
 */
class MvcTest {
    private static string $serviceName = "Test";

    private static string $className = "MvcTest";

    /**
     * 获取消息列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function messageList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->messageList($_params);
    }

    /**
     * 获取消息详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getMessageDetail (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMessageDetail($_params);
    }

    /**
     * 添加消息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function addMessage (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addMessage($_params);
    }

    /**
     * 更新消息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function updateMessage (int $messageId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateMessage(array_merge($_params, ["messageId" => $messageId]));
    }

    /**
     * 删除消息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteMessage (int $messageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteMessage(["messageId" => $messageId]);
    }

    /**
     * 获取服务器时间
     * @return  int
    */
    public static function getServerTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServerTime();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}