<?php
namespace Mainto\Bridge\Invokes\Test\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getExaminationRecordListByParams(array $params)
 * @method getExaminationRecordByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 */
class ExaminationRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 分页获取练习考核记录列表
     *
     * @param  int $task_id 任务id [Original type uint] [ require true ]
     * @support  string $name 员工姓名 
     * @support  string $status 状态 
     * @support  string $submit_at_begin 提交时间开始 
     * @support  string $submit_at_end 提交时间结束 
     * @support  array $department_ids 部门ids 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $page_size page_size [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExaminationRecordList (int $task_id, int $page = 1, int $page_size = 10) {
        return self::getClass()->getExaminationRecordList([
            "task_id" => $task_id,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取练习考核记录详情
     *
     * @param  int $record_id 记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExaminationRecord (int $record_id) {
        return self::getClass()->getExaminationRecord([
            "record_id" => $record_id,
        ]);
    }

    /**
     * 评分通过
     *
     * @param  int $record_id 记录id [Original type uint] [ require true ]
     * @param  array $review_item 评分详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass (int $record_id, array $review_item) {
        return self::getClass()->pass([
            "record_id" => $record_id,
            "review_item" => $review_item,
        ]);
    }

    /**
     * 评分退回
     *
     * @param  int $record_id 记录id [Original type uint] [ require true ]
     * @param  array $review_item 评分详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reject (int $record_id, array $review_item) {
        return self::getClass()->reject([
            "record_id" => $record_id,
            "review_item" => $review_item,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'Manage\ExaminationRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Test', 'Manage\ExaminationRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}