<?php
namespace Mainto\Bridge\Invokes\Test\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getExaminationRecordByParams(array $params)
 * @method getExaminationRecordListByParams(array $params)
 * @method submitByParams(array $params)
 * @method refreshByParams(array $params)
 * @method beginExamByParams(array $params)
 * @method exitByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 */
class ExaminationRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取练习考核记录详情
     *
     * @param  int $record_id 记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExaminationRecord (int $record_id) {
        return self::getClass()->getExaminationRecord([
            "record_id" => $record_id,
        ]);
    }

    /**
     * 分页获取练习考核记录列表
     *
     * @param  int $task_id 任务id [Original type uint] [ require true ]
     * @support  int $page page [Original type uint] 
     * @support  int $page_size page_size [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getExaminationRecordList (int $task_id) {
        return self::getClass()->getExaminationRecordList([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 提交练习/考核数据
     *
     * @param  int $record_id 记录id [Original type uint] [ require true ]
     * @param  array $submit_item 评分详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $record_id, array $submit_item) {
        return self::getClass()->submit([
            "record_id" => $record_id,
            "submit_item" => $submit_item,
        ]);
    }

    /**
     * 刷新题目
     *
     * @param  int $record_id 记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refresh (int $record_id) {
        return self::getClass()->refresh([
            "record_id" => $record_id,
        ]);
    }

    /**
     * 开始练习/考核
     *
     * @param  int $record_id 记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function beginExam (int $record_id) {
        return self::getClass()->beginExam([
            "record_id" => $record_id,
        ]);
    }

    /**
     * 退出练习/考核
     *
     * @param  int $record_id 记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exit (int $record_id) {
        return self::getClass()->exit([
            "record_id" => $record_id,
        ]);
    }

    /**
     * 获取又拍云签名
     *
     * @param  string $upyun_key upyun_key [ require true ]
     * @support  bool $isDown isDown 
     * @throws  \Exception
     * @return  array
     */
    public static function getUpyunSign (string $upyun_key) {
        return self::getClass()->getUpyunSign([
            "upyun_key" => $upyun_key,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'User\ExaminationRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Test', 'User\ExaminationRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}