<?php
namespace Mainto\Bridge\Invokes\Test\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkQuestionBankNameActiveByParams(array $params)
 * @method addQuestionBankByParams(array $params)
 * @method editQuestionBankByParams(array $params)
 * @method deleteQuestionBankByParams(array $params)
 * @method getQuestionBankListByParams(array $params)
 * @method getQuestionBankByParams(array $params)
 */
class QuestionBank {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检测题库名称可用
     *
     * @param  string $name 题库名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkQuestionBankNameActive (string $name) {
        return self::getClass()->checkQuestionBankNameActive([
            "name" => $name,
        ]);
    }

    /**
     * 创建
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $type 类型 [ require true ]
     * @param  int $count 题目数量 [Original type uint] [ require true ]
     * @param  array $questions 题目 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addQuestionBank (string $name, string $type, int $count, array $questions) {
        return self::getClass()->addQuestionBank([
            "name" => $name,
            "type" => $type,
            "count" => $count,
            "questions" => $questions,
        ]);
    }

    /**
     * 修改
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $name 名称 
     * @support  string $type 类型 
     * @support  int $count 题目数量 [Original type uint] 
     * @support  array $questions 题目 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editQuestionBank (int $id) {
        return self::getClass()->editQuestionBank([
            "id" => $id,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteQuestionBank (int $id) {
        return self::getClass()->deleteQuestionBank([
            "id" => $id,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $name 名称 
     * @support  string $type 类型 
     * @support  string $status 状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getQuestionBankList (int $page = 1, int $page_size = 10) {
        return self::getClass()->getQuestionBankList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getQuestionBank (int $id) {
        return self::getClass()->getQuestionBank([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'Manage\QuestionBank');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Test', 'Manage\QuestionBank');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}