<?php
namespace Mainto\Bridge\Invokes\Test\Example;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method remoteNotFoundByParams(array $params)
 * @method rcpLogPushByParams(array $params)
 * @method remoteCallTestByParams(array $params)
 * @method remoteCallTestWithObjectByParams(array $params)
 */
class Rpc {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 服务不存在
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function remoteNotFound () {
        return self::getClass()->remoteNotFound();
    }

    /**
     * 日志推送
     *
     * @throws  \Exception
     * @return  array
     */
    public static function rcpLogPush () {
        return self::getClass()->rcpLogPush();
    }

    /**
     * 远程调用示例
     *
     * @throws  \Exception
     * @return  int
     */
    public static function remoteCallTest () {
        return self::getClass()->remoteCallTest();
    }

    /**
     * 如果底层的函数接收参数部分定义的就是对象，那在这儿可以直接使用对象做入参使用;
     *
     * @throws  \Exception
     * @return  array
     */
    public static function remoteCallTestWithObject () {
        return self::getClass()->remoteCallTestWithObject();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'Example\Rpc');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Test', 'Example\Rpc');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}