<?php
namespace Mainto\Bridge\Invokes\Test\Example;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cronTestByParams(array $params)
 * @method cronTest2ByParams(array $params)
 * @method cronTest3ByParams(array $params)
 * @method getCronLogByParams(array $params)
 */
class Crontab {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * cron 格式的字符串
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronTest () {
        return self::getClass()->cronTest();
    }

    /**
     * cronTest2
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronTest2 () {
        return self::getClass()->cronTest2();
    }

    /**
     * cronTest3
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronTest3 () {
        return self::getClass()->cronTest3();
    }

    /**
     * 需要和CrontabController中的 Cache::put() 配合起来使用，基础缓存也是这么使用的
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCronLog () {
        return self::getClass()->getCronLog();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'Example\Crontab');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Test', 'Example\Crontab');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}