<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-29 11:00:17
 */
namespace Mainto\Bridge\Invokes\Test;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class MvcTest
 */
class MvcTest {
    private static string $serviceName = "Test";

    private static string $className = "MvcTest";

    /**
     * 获取消息列表
     * @return  array
    */
    public static function messageList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->messageList(["page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取消息详情
     * @return  array
    */
    public static function getMessageDetail (int $messageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMessageDetail(["messageId" => $messageId]);
    }
    /**
     * 添加消息
     * @return  bool
    */
    public static function addMessage (string $content, string $type, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addMessage(["content" => $content, "type" => $type, "extend" => $extend]);
    }
    /**
     * 更新消息
     * @return  bool
    */
    public static function updateMessage (int $messageId, string $content, string $type, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateMessage(["messageId" => $messageId, "content" => $content, "type" => $type, "extend" => $extend]);
    }
    /**
     * 删除消息
     * @return  bool
    */
    public static function deleteMessage (int $messageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteMessage(["messageId" => $messageId]);
    }
    /**
     * 获取服务器时间
     * @return  int
    */
    public static function getServerTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServerTime();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}