<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-29 10:52:46
 */
namespace Mainto\Bridge\Invokes\Test;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Example
 */
class Example {
    private static string $serviceName = "Test";

    private static string $className = "Example";

    /**
     * sayHello
     * @return  string
    */
    public static function sayHello (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHello(["name" => $name]);
    }
    /**
     * sayHello.validation
     * @return  array
    */
    public static function sayHelloValidation (string $name, \Mainto\Bridge\Structs\Test\Example\SayHelloValidationParamsHobby $hobby) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHelloValidation(["name" => $name, "hobby" => $hobby]);
    }
    /**
     * sayHelloWithAuth
     * @return  string
    */
    public static function sayHelloWithAuth (int $age, string $name = 'world', string $sex) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHelloWithAuth(["age" => $age, "name" => $name, "sex" => $sex]);
    }
    /**
     * sayHelloWithManyParams
     * @return  \Mainto\RpcServer\Util\Types\Map
    */
    public static function sayHelloWithManyParams (string $sex,  $hobby, int $staffId, int $age = 18, string $realIp = '', string $name = 'world') {
        return RpcClass::getClass(self::$serviceName, self::$className)->sayHelloWithManyParams(["sex" => $sex, "hobby" => $hobby, "staffId" => $staffId, "age" => $age, "realIp" => $realIp, "name" => $name]);
    }
    /**
     * sayObject
     * @return  \Mainto\Bridge\Structs\Test\DTO\SayObjectDTO
    */
    public static function sayObject (\Mainto\Bridge\Structs\Test\Cmd\SayObjectCmd $sayObjectCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->sayObject($sayObjectCmd),
            "\Mainto\Bridge\Structs\Test\DTO\SayObjectDTO"
        );
    }
    /**
     * 获取主机名
     * @return  string
    */
    public static function getHostname (bool $isRpcHostname = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHostname(["isRpcHostname" => $isRpcHostname]);
    }
    /**
     * 获取服务命名空间
     * @return  string
    */
    public static function getNamespace () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNamespace();
    }
    /**
     * 获取图片
     * @return  string
    */
    public static function getImage () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getImage();
    }
    /**
     * 返回错误码未提前定义的错误
     * @return  void
    */
    public static function errorExample () {
         RpcClass::getClass(self::$serviceName, self::$className)->errorExample();
    }
    /**
     * 返回错误码提前定义的错误
     * @return  void
    */
    public static function errorExampleSpecial () {
         RpcClass::getClass(self::$serviceName, self::$className)->errorExampleSpecial();
    }
    /**
     * setting
     * @return  string
    */
    public static function setting () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setting();
    }
    /**
     * object request
     * @return  \Mainto\Bridge\Structs\Test\DTO\ObjectRequestDTO
    */
    public static function objectRequest (\Mainto\Bridge\Structs\Test\Cmd\ObjectRequestCmd $objectRequestCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->objectRequest($objectRequestCmd),
            "\Mainto\Bridge\Structs\Test\DTO\ObjectRequestDTO"
        );
    }
    /**
     * 无锁并发测试
     * @return  int
    */
    public static function noLockTest () {
        return RpcClass::getClass(self::$serviceName, self::$className)->noLockTest();
    }
    /**
     * 有锁并发测试
     * @return  int
    */
    public static function lockTest () {
        return RpcClass::getClass(self::$serviceName, self::$className)->lockTest();
    }
    /**
     * getHeaders
     * @return  array
    */
    public static function getHeaders () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHeaders();
    }
    /**
     * getRequestIp
     * @return  string
    */
    public static function getRequestIp () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRequestIp();
    }
    /**
     * visit
     * @return  int
    */
    public static function visit () {
        return RpcClass::getClass(self::$serviceName, self::$className)->visit();
    }
    /**
     * usleep
     * @return  mixed
    */
    public static function usleep (int $time = 10000) {
        return RpcClass::getClass(self::$serviceName, self::$className)->usleep(["time" => $time]);
    }
    /**
     * sleep
     * @return  mixed
    */
    public static function sleep (int $time = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sleep(["time" => $time]);
    }
    /**
     * helloJava
     * @return  mixed
    */
    public static function helloJava () {
        return RpcClass::getClass(self::$serviceName, self::$className)->helloJava();
    }
    /**
     * helloJavaFromSdk
     * @return  mixed
    */
    public static function helloJavaFromSdk () {
        return RpcClass::getClass(self::$serviceName, self::$className)->helloJavaFromSdk();
    }
    /**
     * exampleException
     * @return  mixed
    */
    public static function exampleException () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exampleException();
    }
    /**
     * notReportExampleException
     * @return  mixed
    */
    public static function notReportExampleException () {
        return RpcClass::getClass(self::$serviceName, self::$className)->notReportExampleException();
    }
    /**
     * exampleExceptionBodyArray
     * @return  mixed
    */
    public static function exampleExceptionBodyArray () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exampleExceptionBodyArray();
    }
    /**
     * innerRpcMethod
     * @return  string
    */
    public static function innerRpcMethod (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->innerRpcMethod(["name" => $name]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}