<?php
namespace Mainto\Bridge\Invokes\Test;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method messageListByParams(array $params)
 * @method getMessageDetailByParams(array $params)
 * @method addMessageByParams(array $params)
 * @method updateMessageByParams(array $params)
 * @method deleteMessageByParams(array $params)
 * @method getServerTimeByParams(array $params)
 */
class MvcTest {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取消息列表
     *
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 页码大小 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function messageList () {
        return self::getClass()->messageList([
        ]);
    }

    /**
     * 获取消息详情
     *
     * @support  int $messageId 消息id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMessageDetail () {
        return self::getClass()->getMessageDetail([
        ]);
    }

    /**
     * 添加消息
     *
     * @support  string $content 消息内容 [ require true ]
     * @support  string $type 消息内容 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addMessage () {
        return self::getClass()->addMessage([
        ]);
    }

    /**
     * 更新消息
     *
     * @param  int $messageId 消息内容 [ require true ]
     * @support  string $content 消息内容 [ require false ]
     * @support  string $type 消息内容 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateMessage (int $messageId) {
        return self::getClass()->updateMessage([
            "messageId" => $messageId,
        ]);
    }

    /**
     * 删除消息
     *
     * @param  int $messageId 消息内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteMessage (int $messageId) {
        return self::getClass()->deleteMessage([
            "messageId" => $messageId,
        ]);
    }

    /**
     * 获取服务器时间
     *
     * @throws  \Exception
     * @return  int
     */
    public static function getServerTime () {
        return self::getClass()->getServerTime();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Test', 'MvcTest');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Test', 'MvcTest');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}