<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-03 12:39:27
 */
namespace Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command;

class CreateCommand {
    /**
     * @var  null|int
     * 反馈人Id
     * validation: 
     */
    public ?int $sender = null;
    /**
     * @var  string
     * 咨询内容
     * validation: 
     */
    public string $content;
    /**
     * @var  array
     * 附件
     * validation: 
     */
    public array $appendix = [];
    /**
     * @var  string
     * 问题分类(默认未分类)
     * validation: 
     */
    public string $category = "default";
    /**
     * @var  string
     * 反馈来源域名 location.host
     * validation: max:128
     */
    public string $origin;
    /**
     * @var  string
     * 反馈来源中文描述
     * validation: 
     */
    public string $referText;
    /**
     * @var  null|string
     * 
     * validation: 
     */
    public ?string $orderNo = null;

    public function __construct (int $currentStaffId = 0, string $content = '', string $origin = '', string $referText = '', string $clientIP = '') {
        if (!is_null($currentStaffId)) {
            $this->currentStaffId = $currentStaffId;
        }
        if (!is_null($content)) {
            $this->content = $content;
        }
        if (!is_null($origin)) {
            $this->origin = $origin;
        }
        if (!is_null($referText)) {
            $this->referText = $referText;
        }
        if (!is_null($clientIP)) {
            $this->clientIP = $clientIP;
        }
    }

    public static function create(int $currentStaffId = 0, string $content = '', string $origin = '', string $referText = '', string $clientIP = ''): self {
        return new self($currentStaffId, $content, $origin, $referText, $clientIP);
    }

    public function setSender(?int $sender): self {
        $this->sender = $sender;

        return $this;
    }

    public function setContent(string $content): self {
        $this->content = $content;

        return $this;
    }

    public function setAppendix(array $appendix): self {
        $this->appendix = $appendix;

        return $this;
    }

    public function setCategory(string $category): self {
        $this->category = $category;

        return $this;
    }

    public function setOrigin(string $origin): self {
        $this->origin = $origin;

        return $this;
    }

    public function setReferText(string $referText): self {
        $this->referText = $referText;

        return $this;
    }

    public function setOrderNo(?string $orderNo): self {
        $this->orderNo = $orderNo;

        return $this;
    }
}