<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-03 18:14:00
 */
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 * @method getStaffListByParams(array $params) 获取员工列表
 * @method getStaffInfoByParams(array $params) getStaffInfo
 * @method getStaffDingInfoByParams(array $params) getStaffDingInfo
 * @method addStaffByParams(array $params) addStaff
 */
class Staff {
    private static string $serviceName = "TechnicalUtils";

    private static string $className = "Staff";

    /**
     * 获取员工列表
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\Staff\Http\DTO\StaffListDTO
    */
    public static function getStaffList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStaffList([]),
            "\Mainto\Bridge\Structs\TechnicalUtils\Staff\Http\DTO\StaffListDTO"
        );
    }
    /**
     * getStaffInfo
     * @return  \Mainto\RpcServer\Util\Types\Map
    */
    public static function getStaffInfo (array $staffIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStaffInfo(["staffIds" => $staffIds]),
            "\Mainto\RpcServer\Util\Types\Map<string, \Mainto\Bridge\Structs\TechnicalUtils\Staff\Http\DTO\StaffDTO>"
        );
    }
    /**
     * getStaffDingInfo
     * @return  \Mainto\RpcServer\Util\Types\Map
    */
    public static function getStaffDingInfo (array $staffIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStaffDingInfo(["staffIds" => $staffIds]),
            "\Mainto\RpcServer\Util\Types\Map<string, \Mainto\Bridge\Structs\TechnicalUtils\Staff\Http\DTO\StaffDingInfoDTO>"
        );
    }
    /**
     * addStaff
     * @return  mixed
    */
    public static function addStaff (\Mainto\Bridge\Structs\TechnicalUtils\Staff\Http\Command\AddStaffCommand $addStaffCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStaff($addStaffCommand);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}