<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-03 18:14:00
 */
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Setting
 * @method getSettingListByParams(array $params) 获取配置列表
 * @method getSettingListUseTokenByParams(array $params) 获取配置列表
 * @method putSettingByParams(array $params) 放入设置
 * @method putSettingUseTokenByParams(array $params) 使用token保存设置
 * @method getHistoryVersionByParams(array $params) 获取历史版本
 * @method getSettingByParams(array $params) 获取设置
 * @method getSettingUseTokenByParams(array $params) 使用token获取设置
 * @method deleteSettingByParams(array $params) 删除设置
 * @method deleteSettingUseTokenByParams(array $params) 使用token删除设置
 */
class Setting {
    private static string $serviceName = "TechnicalUtils";

    private static string $className = "Setting";

    /**
     * 获取配置列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getSettingList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSettingList(array_merge($_params, []));
    }
    /**
     * 获取配置列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getSettingListUseToken (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSettingListUseToken(array_merge($_params, []));
    }
    /**
     * 放入设置
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function putSetting (string $serviceName, string $settingName, string $configJson, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->putSetting(array_merge($_params, ["serviceName" => $serviceName, "settingName" => $settingName, "configJson" => $configJson]));
    }
    /**
     * 使用token保存设置
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes
    */
    public static function putSettingUseToken (\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\PutSettingDto $putSettingDto) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->putSettingUseToken($putSettingDto),
            "\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes"
        );
    }
    /**
     * 获取历史版本
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getHistoryVersion (string $serviceName, string $settingName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryVersion(array_merge($_params, ["serviceName" => $serviceName, "settingName" => $settingName]));
    }
    /**
     * 获取设置
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes
    */
    public static function getSetting (\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $getSettingDto) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSetting($getSettingDto),
            "\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes"
        );
    }
    /**
     * 使用token获取设置
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes
    */
    public static function getSettingUseToken (\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $getSettingDto) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSettingUseToken($getSettingDto),
            "\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes"
        );
    }
    /**
     * 删除设置
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function deleteSetting (string $serviceName, string $settingName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSetting(array_merge($_params, ["serviceName" => $serviceName, "settingName" => $settingName]));
    }
    /**
     * 使用token删除设置
     * @return  mixed
    */
    public static function deleteSettingUseToken (\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $getSettingDto) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSettingUseToken($getSettingDto);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}