<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-03 18:14:00
 */
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class AppLogin
 * @method loginByParams(array $params) App 持久化登陆
 * @method getLoginCodeByParams(array $params) 获取 App 持久化 Code
 */
class AppLogin {
    private static string $serviceName = "TechnicalUtils";

    private static string $className = "AppLogin";

    /**
     * App 持久化登陆
     * @return  string
    */
    public static function login (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->login(["code" => $code]);
    }
    /**
     * 获取 App 持久化 Code
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  string
    */
    public static function getLoginCode () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLoginCode();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}