<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-13 16:09:49
 */
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class WorkOrder
 */
class WorkOrder {
    private static string $serviceName = "TechnicalUtils";

    private static string $className = "WorkOrder";

    /**
     * create
     *
     */
    public static function create (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\CreateCommand $createCommand): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createCommand);
    }
    /**
     * createByAdmin
     *
     */
    public static function createByAdmin (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\CreateByAdminCommand $createByAdminCommand): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->createByAdmin($createByAdminCommand);
    }
    /**
     * delete
     *
     */
    public static function delete (int $workOrderId, int $operator): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["workOrderId" => $workOrderId, "operator" => $operator, ]);
    }
    /**
     * 获取上传签名
     *
     */
    public static function getUploadToken (): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUploadToken();
    }
    /**
     * detail
     *
     */
    public static function detail (int $workOrderId): \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["workOrderId" => $workOrderId, ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }
    /**
     * count
     *
     */
    public static function count (): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->count();
    }
    /**
     * reporterCount
     *
     */
    public static function reporterCount (): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->reporterCount();
    }
    /**
     * notFinishedCount
     *
     */
    public static function notFinishedCount (): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->notFinishedCount();
    }
    /**
     * bugCount
     *
     */
    public static function bugCount (): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->bugCount();
    }
    /**
     * codingInfo
     *
     */
    public static function codingInfo (int $workOrderId): \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\CodingInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->codingInfo(["workOrderId" => $workOrderId, ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\CodingInfoDTO"
        );
    }
    /**
     * list
     *
     */
    public static function list (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\ListCommand $listCommand): \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\ListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($listCommand),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\ListDTO"
        );
    }
    /**
     * process
     *
     */
    public static function process (int $workOrderId, int $operator): \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->process(["workOrderId" => $workOrderId, "operator" => $operator, ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }
    /**
     * finish
     *
     */
    public static function finish (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\FinishCommand $finishCommand): \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->finish($finishCommand),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }
    /**
     * updateCategory
     *
     */
    public static function updateCategory (int $workOrderId, string $category, int $operator): \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->updateCategory(["workOrderId" => $workOrderId, "category" => $category, "operator" => $operator, ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }
    /**
     * categoriesCount
     *
     */
    public static function categoriesCount (string $createdAtStart, string $createdAtEnd): \Mainto\RpcServer\Util\Types\Map {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->categoriesCount(["createdAtStart" => $createdAtStart, "createdAtEnd" => $createdAtEnd, ]),
            "\Mainto\RpcServer\Util\Types\Map<string, \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\CategoryCountDTO>"
        );
    }
    /**
     * bugChartByDate
     *
     */
    public static function bugChartByDate (string $createdAtStart, string $createdAtEnd, bool $isBug = false): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bugChartByDate(["createdAtStart" => $createdAtStart, "createdAtEnd" => $createdAtEnd, "isBug" => $isBug, ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDateCountDTO[]"
        );
    }
    /**
     * locationToCoding
     *
     */
    public static function locationToCoding (int $workOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->locationToCoding(["workOrderId" => $workOrderId, ]);
    }
    /**
     * createCoding
     *
     */
    public static function createCoding (int $workOrderId): \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createCoding(["workOrderId" => $workOrderId, ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }
    /**
     * resetDeletedCoding
     *
     */
    public static function resetDeletedCoding (string $createdAtStart, string $createdAtEnd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resetDeletedCoding(["createdAtStart" => $createdAtStart, "createdAtEnd" => $createdAtEnd, ]);
    }
    /**
     * getConnectSignature
     *
     */
    public static function getConnectSignature (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getConnectSignature();
    }
    /**
     * send
     *
     */
    public static function send (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\SendCommand $sendCommand): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->send($sendCommand);
    }
    /**
     * reply
     *
     */
    public static function reply (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\ReplyCommand $replyCommand): \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\MessageDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->reply($replyCommand),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\MessageDTO"
        );
    }
    /**
     * historyMessages
     *
     */
    public static function historyMessages (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\HistoryMessageCommand $historyMessageCommand): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->historyMessages($historyMessageCommand);
    }
    /**
     * removeCodingRelation
     *
     */
    public static function removeCodingRelation (int $workOrderId, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeCodingRelation(["workOrderId" => $workOrderId, "operator" => $operator, ]);
    }
    /**
     * connect
     *
     */
    public static function connect () {
        return RpcClass::getClass(self::$serviceName, self::$className)->connect();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}