<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendByParams(array|OnlineChart\Send\SendCommand $params)
 * @method replyByParams(array|OnlineChart\Reply\ReplyCommand $params)
 * @method historyMessagesByParams(array|OnlineChart\HistoryMessages\HistoryMessageCommand $params)
 */
class OnlineChart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送
     *
     * @var  OnlineChart\Send\SendCommand $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function send (OnlineChart\Send\SendCommand $command) {
        return self::getClass()->send($command);
    }


    /**
     * 回复
     *
     * @var  OnlineChart\Reply\ReplyCommand $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function reply (OnlineChart\Reply\ReplyCommand $command) {
        return self::getClass()->reply($command);
    }


    /**
     * historyMessages
     *
     * @var  OnlineChart\HistoryMessages\HistoryMessageCommand $command $command
     * @throws  \Exception
     * @return  OnlineChart\HistoryMessages\MessageDTO[]
     */
    public static function historyMessages (OnlineChart\HistoryMessages\HistoryMessageCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->historyMessages($command),
            "\Mainto\Bridge\Invokes\TechnicalUtils\OnlineChart\HistoryMessages\MessageDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'OnlineChart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'OnlineChart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}