<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|WorkOrder\Create\CreateCommand $params)
 * @method createByAdminByParams(array|WorkOrder\CreateByAdmin\CreateByAdminCommand $params)
 * @method deleteByParams(array $params)
 * @method getUploadTokenByParams(array $params)
 * @method detailByParams(array $params)
 * @method countByParams(array $params)
 * @method reporterCountByParams(array $params)
 * @method notFinishedCountByParams(array $params)
 * @method bugCountByParams(array $params)
 * @method codingInfoByParams(array $params)
 * @method listByParams(array|WorkOrder\ListSafeNamespace\ListCommand $params)
 * @method processByParams(array $params)
 * @method finishByParams(array|WorkOrder\Finish\FinishCommand $params)
 * @method updateCategoryByParams(array $params)
 * @method bugChartByDateByParams(array $params)
 * @method locationToCodingByParams(array $params)
 * @method createCodingByParams(array $params)
 * @method resetDeletedCodingByParams(array $params)
 * @method getConnectSignatureByParams(array $params)
 * @method sendByParams(array|WorkOrder\Send\SendCommand $params)
 * @method replyByParams(array|WorkOrder\Reply\ReplyCommand $params)
 * @method historyMessagesByParams(array|WorkOrder\HistoryMessages\HistoryMessageCommand $params)
 * @method connectByParams(array $params)
 */
class WorkOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  WorkOrder\Create\CreateCommand $command $command
     * @throws  \Exception
     * @return  int
     */
    public static function create (WorkOrder\Create\CreateCommand $command) {
        return self::getClass()->create($command);
    }


    /**
     * createByAdmin
     *
     * @var  WorkOrder\CreateByAdmin\CreateByAdminCommand $command $command
     * @throws  \Exception
     * @return  int
     */
    public static function createByAdmin (WorkOrder\CreateByAdmin\CreateByAdminCommand $command) {
        return self::getClass()->createByAdmin($command);
    }


    /**
     * delete
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $workOrderId, int $operator) {
        return self::getClass()->delete([
            "workOrderId" => $workOrderId,
            "operator" => $operator,
        ]);
    }

    /**
     * 获取上传签名
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * detail
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  WorkOrder\Detail\WorkOrderDTO
     */
    public static function detail (int $workOrderId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->detail([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\WorkOrder\Detail\WorkOrderDTO"
        );
    }

    /**
     * count
     *
     * @throws  \Exception
     * @return  int
     */
    public static function count () {
        return self::getClass()->count();
    }

    /**
     * reporterCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function reporterCount () {
        return self::getClass()->reporterCount();
    }

    /**
     * notFinishedCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function notFinishedCount () {
        return self::getClass()->notFinishedCount();
    }

    /**
     * bugCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function bugCount () {
        return self::getClass()->bugCount();
    }

    /**
     * codingInfo
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  WorkOrder\CodingInfo\CodingInfoDTO
     */
    public static function codingInfo (int $workOrderId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->codingInfo([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\WorkOrder\CodingInfo\CodingInfoDTO"
        );
    }

    /**
     * list
     *
     * @var  WorkOrder\ListSafeNamespace\ListCommand $command $command
     * @throws  \Exception
     * @return  WorkOrder\ListSafeNamespace\ListDTO
     */
    public static function list (WorkOrder\ListSafeNamespace\ListCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->list($command),
            "\Mainto\Bridge\Invokes\TechnicalUtils\WorkOrder\ListSafeNamespace\ListDTO"
        );
    }


    /**
     * process
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  WorkOrder\Process\WorkOrderDTO
     */
    public static function process (int $workOrderId, int $operator) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->process([
                            "workOrderId" => $workOrderId,
                            "operator" => $operator,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\WorkOrder\Process\WorkOrderDTO"
        );
    }

    /**
     * finish
     *
     * @var  WorkOrder\Finish\FinishCommand $command $command
     * @throws  \Exception
     * @return  WorkOrder\Finish\WorkOrderDTO
     */
    public static function finish (WorkOrder\Finish\FinishCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->finish($command),
            "\Mainto\Bridge\Invokes\TechnicalUtils\WorkOrder\Finish\WorkOrderDTO"
        );
    }


    /**
     * updateCategory
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  string $category 分类 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  WorkOrder\UpdateCategory\WorkOrderDTO
     */
    public static function updateCategory (int $workOrderId, string $category, int $operator) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->updateCategory([
                            "workOrderId" => $workOrderId,
                            "category" => $category,
                            "operator" => $operator,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\WorkOrder\UpdateCategory\WorkOrderDTO"
        );
    }

    /**
     * bugChartByDate
     *
     * @support  string $createdAtStart 创建时间-起 require false
     * @support  string $createdAtEnd 创建时间-止 require false
     * @param  bool $isBug bug [ require true ]
     * @throws  \Exception
     * @return  WorkOrder\BugChartByDate\WorkOrderDateCountDTO[]
     */
    public static function bugChartByDate (bool $isBug = false) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->bugChartByDate([
                            "isBug" => $isBug,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\WorkOrder\BugChartByDate\WorkOrderDateCountDTO[]"
        );
    }

    /**
     * locationToCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function locationToCoding (int $workOrderId) {
        return self::getClass()->locationToCoding([
            "workOrderId" => $workOrderId,
        ]);
    }

    /**
     * createCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  WorkOrder\CreateCoding\WorkOrderDTO
     */
    public static function createCoding (int $workOrderId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->createCoding([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\WorkOrder\CreateCoding\WorkOrderDTO"
        );
    }

    /**
     * resetDeletedCoding
     *
     * @support  string $createdAtStart 创建时间-起 require false
     * @support  string $createdAtEnd 创建时间-止 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetDeletedCoding () {
        return self::getClass()->resetDeletedCoding();
    }

    /**
     * getConnectSignature
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getConnectSignature () {
        return self::getClass()->getConnectSignature();
    }

    /**
     * send
     *
     * @var  WorkOrder\Send\SendCommand $command $command
     * @throws  \Exception
     * @return  int
     */
    public static function send (WorkOrder\Send\SendCommand $command) {
        return self::getClass()->send($command);
    }


    /**
     * reply
     *
     * @var  WorkOrder\Reply\ReplyCommand $command $command
     * @throws  \Exception
     * @return  WorkOrder\Reply\MessageDTO
     */
    public static function reply (WorkOrder\Reply\ReplyCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->reply($command),
            "\Mainto\Bridge\Invokes\TechnicalUtils\WorkOrder\Reply\MessageDTO"
        );
    }


    /**
     * historyMessages
     *
     * @var  WorkOrder\HistoryMessages\HistoryMessageCommand $command $command
     * @throws  \Exception
     * @return  array
     */
    public static function historyMessages (WorkOrder\HistoryMessages\HistoryMessageCommand $command) {
        return self::getClass()->historyMessages($command);
    }


    /**
     * connect
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function connect () {
        return self::getClass()->connect();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'WorkOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'WorkOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}