<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|ShortUrl\Create\CreateCommand $params)
 */
class ShortUrl {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  ShortUrl\Create\CreateCommand $dto $dto
     * @throws  \Exception
     * @return  ShortUrl\Create\ShortUrlDTO
     */
    public static function create (ShortUrl\Create\CreateCommand $dto) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->create($dto),
            "\Mainto\Bridge\Invokes\TechnicalUtils\ShortUrl\Create\ShortUrlDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'ShortUrl');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'ShortUrl');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}