<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffListByParams(array $params)
 * @method getStaffInfoByParams(array $params)
 * @method getStaffDingInfoByParams(array $params)
 * @method addStaffByParams(array|Staff\AddStaff\AddStaffCommand $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getStaffList
     *
     * @param  string $keyword 关键词搜索 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页大小 [ require true ]
     * @throws  \Exception
     * @return  Staff\GetStaffList\StaffListDTO
     */
    public static function getStaffList (string $keyword = '', int $page = 1, int $pageSize = 15) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getStaffList([
                            "keyword" => $keyword,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\Staff\GetStaffList\StaffListDTO"
        );
    }

    /**
     * getStaffInfo
     *
     * @param  array $staffIds 伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  Map&lt;string|int, App\Interfaces\Staff\Http\DTO\StaffDTO&gt;
     */
    public static function getStaffInfo (array $staffIds) {
        return self::getClass()->getStaffInfo([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * getStaffDingInfo
     *
     * @param  array $staffIds 伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  Map&lt;string|int, App\Interfaces\Staff\Http\DTO\StaffDingInfoDTO&gt;
     */
    public static function getStaffDingInfo (array $staffIds) {
        return self::getClass()->getStaffDingInfo([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * addStaff
     *
     * @var  Staff\AddStaff\AddStaffCommand $addStaffCommand $addStaffCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStaff (Staff\AddStaff\AddStaffCommand $addStaffCommand) {
        return self::getClass()->addStaff($addStaffCommand);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}