<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveFineReportUserByParams(array $params)
 * @method listFineReportUserByParams(array $params)
 * @method removeFineReportUserByParams(array $params)
 * @method getFineReportPasswordByParams(array $params)
 */
class FineReport {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 保存帆软用户名密码
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  string $userName 用户名 [ require true ]
     * @param  string $password 密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveFineReportUser (int $staffId, string $userName, string $password) {
        return self::getClass()->saveFineReportUser([
            "staffId" => $staffId,
            "userName" => $userName,
            "password" => $password,
        ]);
    }

    /**
     * 列出帆软用户
     *
     * @param  int $page 当前页码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listFineReportUser (int $page = 1) {
        return self::getClass()->listFineReportUser([
            "page" => $page,
        ]);
    }

    /**
     * 删除帆软用户
     *
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeFineReportUser (int $staffId) {
        return self::getClass()->removeFineReportUser([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取帆软密码
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFineReportPassword () {
        return self::getClass()->getFineReportPassword();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'FineReport');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'FineReport');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}