<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils\App\Interfaces\Staff\Http\Controllers;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffInfoByParams(array $params)
 * @method getStaffDingInfoByParams(array $params)
 * @method addStaffByParams(array|AddStaff\AddStaffCommand $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getStaffInfo
     *
     * @param  array $staffIds 伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  Map&lt;string|int, App\Interfaces\Staff\Http\DTO\StaffDTO&gt;
     */
    public static function getStaffInfo (array $staffIds) {
        return self::getClass()->getStaffInfo([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * getStaffDingInfo
     *
     * @param  array $staffIds 伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  Map&lt;string|int, App\Interfaces\Staff\Http\DTO\StaffDingInfoDTO&gt;
     */
    public static function getStaffDingInfo (array $staffIds) {
        return self::getClass()->getStaffDingInfo([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * addStaff
     *
     * @var  AddStaff\AddStaffCommand $addStaffCommand $addStaffCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStaff (AddStaff\AddStaffCommand $addStaffCommand) {
        return self::getClass()->addStaff($addStaffCommand);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}