<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils\App\Interfaces\OnlineChart\Http\Controllers;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendByParams(array|Send\SendCommand $params)
 * @method replyByParams(array|Reply\ReplyCommand $params)
 * @method historyMessagesByParams(array|HistoryMessages\HistoryMessageCommand $params)
 */
class OnlineChart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送
     *
     * @var  Send\SendCommand $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function send (Send\SendCommand $command) {
        return self::getClass()->send($command);
    }


    /**
     * 回复
     *
     * @var  Reply\ReplyCommand $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function reply (Reply\ReplyCommand $command) {
        return self::getClass()->reply($command);
    }


    /**
     * historyMessages
     *
     * @var  HistoryMessages\HistoryMessageCommand $command $command
     * @throws  \Exception
     * @return  HistoryMessages\MessageDTO[]
     */
    public static function historyMessages (HistoryMessages\HistoryMessageCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->historyMessages($command),
            "\Mainto\Bridge\Invokes\TechnicalUtils\App\Interfaces\OnlineChart\Http\Controllers\HistoryMessages\MessageDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'OnlineChart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'OnlineChart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}