<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffInfoByParams(array $params)
 * @method getStaffDingInfoByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getStaffInfo
     *
     * @param  array $staffIds 伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  Map&lt;string|int, App\Domain\Common\Staff\Dto\GetStaffByStaffIdRes&gt;
     */
    public static function getStaffInfo (array $staffIds) {
        return self::getClass()->getStaffInfo([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * getStaffDingInfo
     *
     * @param  array $staffIds 伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  Map&lt;string|int, App\Domain\Common\Staff\Dto\StaffDingInfoRes&gt;
     */
    public static function getStaffDingInfo (array $staffIds) {
        return self::getClass()->getStaffDingInfo([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}