<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\ShortUrl\Http\Command\CreateCommand $params)
 */
class ShortUrl {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\ShortUrl\Http\Command\CreateCommand $dto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\ShortUrl\Http\DTO\ShortUrlDTO
     */
    public static function create (\Mainto\Bridge\Structs\TechnicalUtils\ShortUrl\Http\Command\CreateCommand $dto) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($dto),
            "\Mainto\Bridge\Structs\TechnicalUtils\ShortUrl\Http\DTO\ShortUrlDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'ShortUrl');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'ShortUrl');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}