<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\OnlineChart\Http\Command\SendCommand $params)
 * @method replyByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\OnlineChart\Http\Command\ReplyCommand $params)
 * @method historyMessagesByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\OnlineChart\Http\Command\HistoryMessageCommand $params)
 */
class OnlineChart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\OnlineChart\Http\Command\SendCommand $command
     * @throws  \Exception
     * @return  bool
     */
    public static function send (\Mainto\Bridge\Structs\TechnicalUtils\OnlineChart\Http\Command\SendCommand $command) {
        return self::getClass()->send($command);
    }


    /**
     * 回复
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\OnlineChart\Http\Command\ReplyCommand $command
     * @throws  \Exception
     * @return  bool
     */
    public static function reply (\Mainto\Bridge\Structs\TechnicalUtils\OnlineChart\Http\Command\ReplyCommand $command) {
        return self::getClass()->reply($command);
    }


    /**
     * historyMessages
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\OnlineChart\Http\Command\HistoryMessageCommand $command
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\MessageDTO[]
     */
    public static function historyMessages (\Mainto\Bridge\Structs\TechnicalUtils\OnlineChart\Http\Command\HistoryMessageCommand $command) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->historyMessages($command),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\MessageDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'OnlineChart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'OnlineChart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}