<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\CreateCommand $params)
 * @method createByAdminByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\CreateByAdminCommand $params)
 * @method deleteByParams(array $params)
 * @method getUploadTokenByParams(array $params)
 * @method detailByParams(array $params)
 * @method countByParams(array $params)
 * @method reporterCountByParams(array $params)
 * @method notFinishedCountByParams(array $params)
 * @method bugCountByParams(array $params)
 * @method codingInfoByParams(array $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\ListCommand $params)
 * @method processByParams(array $params)
 * @method finishByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\FinishCommand $params)
 * @method updateCategoryByParams(array $params)
 * @method categoriesCountByParams(array $params)
 * @method bugChartByDateByParams(array $params)
 * @method locationToCodingByParams(array $params)
 * @method createCodingByParams(array $params)
 * @method resetDeletedCodingByParams(array $params)
 * @method getConnectSignatureByParams(array $params)
 * @method sendByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\SendCommand $params)
 * @method replyByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\ReplyCommand $params)
 * @method historyMessagesByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\HistoryMessageCommand $params)
 * @method removeCodingRelationByParams(array $params)
 * @method connectByParams(array $params)
 */
class WorkOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\CreateCommand $command
     * @throws  \Exception
     * @return  int
     */
    public static function create (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\CreateCommand $command) {
        return self::getClass()->create($command);
    }


    /**
     * createByAdmin
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\CreateByAdminCommand $command
     * @throws  \Exception
     * @return  int
     */
    public static function createByAdmin (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\CreateByAdminCommand $command) {
        return self::getClass()->createByAdmin($command);
    }


    /**
     * delete
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $workOrderId, int $operator) {
        return self::getClass()->delete([
            "workOrderId" => $workOrderId,
            "operator" => $operator,
        ]);
    }

    /**
     * 获取上传签名
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * detail
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO
     */
    public static function detail (int $workOrderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }

    /**
     * count
     *
     * @throws  \Exception
     * @return  int
     */
    public static function count () {
        return self::getClass()->count();
    }

    /**
     * reporterCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function reporterCount () {
        return self::getClass()->reporterCount();
    }

    /**
     * notFinishedCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function notFinishedCount () {
        return self::getClass()->notFinishedCount();
    }

    /**
     * bugCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function bugCount () {
        return self::getClass()->bugCount();
    }

    /**
     * codingInfo
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\CodingInfoDTO
     */
    public static function codingInfo (int $workOrderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->codingInfo([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\CodingInfoDTO"
        );
    }

    /**
     * list
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\ListCommand $command
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\ListDTO
     */
    public static function list (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\ListCommand $command) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($command),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\ListDTO"
        );
    }


    /**
     * process
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO
     */
    public static function process (int $workOrderId, int $operator) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->process([
                            "workOrderId" => $workOrderId,
                            "operator" => $operator,
                        ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }

    /**
     * finish
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\FinishCommand $command
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO
     */
    public static function finish (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\FinishCommand $command) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->finish($command),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }


    /**
     * updateCategory
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  string $category 分类 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO
     */
    public static function updateCategory (int $workOrderId, string $category, int $operator) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->updateCategory([
                            "workOrderId" => $workOrderId,
                            "category" => $category,
                            "operator" => $operator,
                        ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }

    /**
     * categoriesCount
     *
     * @support  string $createdAtStart 创建时间-起 [ require false ]
     * @support  string $createdAtEnd 创建时间-止 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\RpcServer\Util\Types\Map<\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\CategoryCountDTO>
     */
    public static function categoriesCount () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->categoriesCount([
                        ]),
            "\Mainto\RpcServer\Util\Types\Map<\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\CategoryCountDTO>"
        );
    }

    /**
     * bugChartByDate
     *
     * @support  string $createdAtStart 创建时间-起 [ require false ]
     * @support  string $createdAtEnd 创建时间-止 [ require false ]
     * @param  bool $isBug bug [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDateCountDTO[]
     */
    public static function bugChartByDate (bool $isBug = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->bugChartByDate([
                            "isBug" => $isBug,
                        ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDateCountDTO[]"
        );
    }

    /**
     * locationToCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function locationToCoding (int $workOrderId) {
        return self::getClass()->locationToCoding([
            "workOrderId" => $workOrderId,
        ]);
    }

    /**
     * createCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO
     */
    public static function createCoding (int $workOrderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createCoding([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }

    /**
     * resetDeletedCoding
     *
     * @support  string $createdAtStart 创建时间-起 [ require false ]
     * @support  string $createdAtEnd 创建时间-止 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetDeletedCoding () {
        return self::getClass()->resetDeletedCoding([
        ]);
    }

    /**
     * getConnectSignature
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getConnectSignature () {
        return self::getClass()->getConnectSignature();
    }

    /**
     * send
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\SendCommand $command
     * @throws  \Exception
     * @return  int
     */
    public static function send (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\SendCommand $command) {
        return self::getClass()->send($command);
    }


    /**
     * reply
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\ReplyCommand $command
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\MessageDTO
     */
    public static function reply (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\ReplyCommand $command) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->reply($command),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\MessageDTO"
        );
    }


    /**
     * historyMessages
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\HistoryMessageCommand $command
     * @throws  \Exception
     * @return  array
     */
    public static function historyMessages (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\HistoryMessageCommand $command) {
        return self::getClass()->historyMessages($command);
    }


    /**
     * removeCodingRelation
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeCodingRelation (int $workOrderId, int $operator) {
        return self::getClass()->removeCodingRelation([
            "workOrderId" => $workOrderId,
            "operator" => $operator,
        ]);
    }

    /**
     * connect
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function connect () {
        return self::getClass()->connect();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'WorkOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'WorkOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}