<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSettingPathByParams(array $params)
 * @method getSettingListUseTokenByParams(array $params)
 * @method putSettingByParams(array $params)
 * @method putSettingUseTokenByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\PutSettingDto $params)
 * @method getHistoryVersionByParams(array $params)
 * @method getSettingByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $params)
 * @method getSettingUseTokenByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $params)
 * @method deleteSettingByParams(array $params)
 * @method deleteSettingUseTokenByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $params)
 */
class Setting {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取配置列表
     *
     * @param  string $serviceName 服务名称 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSettingPath (string $serviceName = null) {
        return self::getClass()->getSettingPath([
            "serviceName" => $serviceName,
        ]);
    }

    /**
     * 获取配置列表
     *
     * @param  string $serviceName 服务名称 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSettingListUseToken (string $serviceName = null) {
        return self::getClass()->getSettingListUseToken([
            "serviceName" => $serviceName,
        ]);
    }

    /**
     * 放入设置
     *
     * @param  string $serviceName 服务名称 [ require true ]
     * @param  string $settingName 设置名称 [ require true ]
     * @param  string $configJson 配置Json [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function putSetting (string $serviceName, string $settingName, string $configJson) {
        return self::getClass()->putSetting([
            "serviceName" => $serviceName,
            "settingName" => $settingName,
            "configJson" => $configJson,
        ]);
    }

    /**
     * 使用token保存设置
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\PutSettingDto $dto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes
     */
    public static function putSettingUseToken (\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\PutSettingDto $dto) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->putSettingUseToken($dto),
            "\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes"
        );
    }


    /**
     * 获取历史版本
     *
     * @param  string $serviceName 服务名称 [ require true ]
     * @param  string $settingName 设置名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHistoryVersion (string $serviceName, string $settingName) {
        return self::getClass()->getHistoryVersion([
            "serviceName" => $serviceName,
            "settingName" => $settingName,
        ]);
    }

    /**
     * 获取设置
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $dto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes
     */
    public static function getSetting (\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $dto) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSetting($dto),
            "\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes"
        );
    }


    /**
     * 使用token获取设置
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $dto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes
     */
    public static function getSettingUseToken (\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $dto) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSettingUseToken($dto),
            "\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingRes"
        );
    }


    /**
     * 删除设置
     *
     * @param  string $serviceName 服务名称 [ require true ]
     * @param  string $settingName 设置名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteSetting (string $serviceName, string $settingName) {
        return self::getClass()->deleteSetting([
            "serviceName" => $serviceName,
            "settingName" => $settingName,
        ]);
    }

    /**
     * 使用token删除设置
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteSettingUseToken (\Mainto\Bridge\Structs\TechnicalUtils\Setting\Dto\GetSettingDto $dto) {
        return self::getClass()->deleteSettingUseToken($dto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'Setting');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'Setting');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}