<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrEditAppByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\Application\Cmd\ApplicationSaveCmd $params)
 * @method getAppDetailByParams(array $params)
 * @method getAppListByParams(array|\Mainto\Bridge\Structs\TechnicalUtils\Application\Cmd\ApplicationSearchCmd $params)
 */
class Application {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建应用
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\Application\Cmd\ApplicationSaveCmd $applicationSaveCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrEditApp (\Mainto\Bridge\Structs\TechnicalUtils\Application\Cmd\ApplicationSaveCmd $applicationSaveCmd) {
        return self::getClass()->createOrEditApp($applicationSaveCmd);
    }


    /**
     * 获取应用详情
     *
     * @param  string $appNo 应用编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\Application\DTO\ApplicationDTO
     */
    public static function getAppDetail (string $appNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAppDetail([
                            "appNo" => $appNo,
                        ]),
            "\Mainto\Bridge\Structs\TechnicalUtils\Application\DTO\ApplicationDTO"
        );
    }

    /**
     * 获取应用列表(全部)
     *
     * @var  \Mainto\Bridge\Structs\TechnicalUtils\Application\Cmd\ApplicationSearchCmd $applicationSearchCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\Application\DTO\ApplicationDTO[]
     */
    public static function getAppList (\Mainto\Bridge\Structs\TechnicalUtils\Application\Cmd\ApplicationSearchCmd $applicationSearchCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAppList($applicationSearchCmd),
            "\Mainto\Bridge\Structs\TechnicalUtils\Application\DTO\ApplicationDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'Application');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'Application');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}