<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method eventByParams(array $params)
 * @method gitlabUserTokenByParams(array $params)
 * @method initGitlabUserByParams(array $params)
 */
class Gitlab {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * Gitlab Event
     *
     * @support  string $object_kind event 类型 require false
     * @support  array $group dingtalk groupId require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function event () {
        return self::getClass()->event();
    }

    /**
     * 生成 Gitlab 用户 jwt token
     *
     * @throws  \Exception
     * @return  string
     */
    public static function gitlabUserToken () {
        return self::getClass()->gitlabUserToken();
    }

    /**
     * 初始化 Gitlab 用户
     *
     * @support  string $email 邮箱 require false
     * @support  string $job 工作类型 require false
     * @support  string $phone 手机号码 require false
     * @throws  \Exception
     * @return  string
     */
    public static function initGitlabUser () {
        return self::getClass()->initGitlabUser();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'Gitlab');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'Gitlab');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}