<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method loginByParams(array $params)
 * @method getLoginCodeByParams(array $params)
 */
class AppLogin {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * App 持久化登陆
     *
     * @param  string $code 授权code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function login (string $code) {
        return self::getClass()->login([
            "code" => $code,
        ]);
    }

    /**
     * 获取 App 持久化 Code
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLoginCode () {
        return self::getClass()->getLoginCode();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'AppLogin');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'AppLogin');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}