<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendByParams(array $params)
 * @method replyByParams(array $params)
 * @method historyMessagesByParams(array $params)
 */
class OnlineChart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送
     *
     * @support  App\Domain\OnlineChart\Vo\MessageContent $content  [ require true ]
     * @support  int $sender  [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function send (App\Domain\OnlineChart\Dto\SendDto $dto) {
        return self::getClass()->send([
            "dto" => $dto,
        ]);
    }

    /**
     * 回复
     *
     * @support  int $chartId  [ require true ]
     * @support  App\Domain\OnlineChart\Vo\MessageContent $content  [ require true ]
     * @support  int $replier  [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function reply (App\Domain\OnlineChart\Dto\ReplyDto $dto) {
        return self::getClass()->reply([
            "dto" => $dto,
        ]);
    }

    /**
     * historyMessages
     *
     * @support  int $chartId  [ require true ]
     * @support  int $beforeMessageId  require false
     * @support  int $limit  require false
     * @throws  \Exception
     * @return  array
     */
    public static function historyMessages (App\Domain\OnlineChart\Dto\HistoryMessageDto $dto) {
        return self::getClass()->historyMessages([
            "dto" => $dto,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'OnlineChart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'OnlineChart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}