<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|Create\CreateDto $params)
 * @method countByParams(array $params)
 * @method reporterCountByParams(array $params)
 * @method listByParams(array|List\ListDto $params)
 * @method locationToCodingByParams(array $params)
 * @method removeDeletedCodingByParams(array $params)
 * @method getConnectSignatureByParams(array $params)
 * @method connectByParams(array $params)
 */
class WorkOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  Create\CreateDto $dto $dto
     * @throws  \Exception
     * @return  int
     */
    public static function create (Create\CreateDto $dto) {
        return self::getClass()->create($dto);
    }


    /**
     * count
     *
     * @throws  \Exception
     * @return  int
     */
    public static function count () {
        return self::getClass()->count();
    }

    /**
     * reporterCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function reporterCount () {
        return self::getClass()->reporterCount();
    }

    /**
     * list
     *
     * @var  List\ListDto $dto $dto
     * @throws  \Exception
     * @return  List\ListRes
     */
    public static function list (List\ListDto $dto) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->list($dto),
            "\Mainto\Bridge\Invokes\TechnicalUtils\List\ListRes"
        );
    }


    /**
     * locationToCoding
     *
     * @param  uint $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function locationToCoding (int $workOrderId) {
        return self::getClass()->locationToCoding([
            "workOrderId" => $workOrderId,
        ]);
    }

    /**
     * removeDeletedCoding
     *
     * @support  string $created_at_start 创建时间-起 require false
     * @support  string $created_at_end 创建时间-止 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeDeletedCoding () {
        return self::getClass()->removeDeletedCoding();
    }

    /**
     * getConnectSignature
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getConnectSignature () {
        return self::getClass()->getConnectSignature();
    }

    /**
     * connect
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function connect () {
        return self::getClass()->connect();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'WorkOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'WorkOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}