<?php
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|Create\CreateDto $params)
 * @method detailByParams(array $params)
 * @method countByParams(array $params)
 * @method reporterCountByParams(array $params)
 * @method notFinishedCountByParams(array $params)
 * @method bugCountByParams(array $params)
 * @method codingInfoByParams(array $params)
 * @method listByParams(array|List\ListDto $params)
 * @method updateStateByParams(array $params)
 * @method updateCategoryByParams(array $params)
 * @method bugChartByDateByParams(array $params)
 * @method locationToCodingByParams(array $params)
 * @method resetDeletedCodingByParams(array $params)
 * @method getConnectSignatureByParams(array $params)
 * @method sendByParams(array $params)
 * @method replyByParams(array $params)
 * @method historyMessagesByParams(array $params)
 * @method connectByParams(array $params)
 */
class WorkOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  Create\CreateDto $dto $dto
     * @throws  \Exception
     * @return  int
     */
    public static function create (Create\CreateDto $dto) {
        return self::getClass()->create($dto);
    }


    /**
     * detail
     *
     * @param  uint $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  Detail\WorkOrder
     */
    public static function detail (int $workOrderId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->detail([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\Detail\WorkOrder"
        );
    }

    /**
     * count
     *
     * @throws  \Exception
     * @return  int
     */
    public static function count () {
        return self::getClass()->count();
    }

    /**
     * reporterCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function reporterCount () {
        return self::getClass()->reporterCount();
    }

    /**
     * notFinishedCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function notFinishedCount () {
        return self::getClass()->notFinishedCount();
    }

    /**
     * bugCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function bugCount () {
        return self::getClass()->bugCount();
    }

    /**
     * codingInfo
     *
     * @param  uint $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  CodingInfo\CodingInfoRes
     */
    public static function codingInfo (int $workOrderId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->codingInfo([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\CodingInfo\CodingInfoRes"
        );
    }

    /**
     * list
     *
     * @var  List\ListDto $dto $dto
     * @throws  \Exception
     * @return  List\ListRes
     */
    public static function list (List\ListDto $dto) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->list($dto),
            "\Mainto\Bridge\Invokes\TechnicalUtils\List\ListRes"
        );
    }


    /**
     * updateState
     *
     * @param  uint $workOrderId 工单ID [ require true ]
     * @param  string $state 状态 [ require true ]
     * @throws  \Exception
     * @return  UpdateState\WorkOrder
     */
    public static function updateState (int $workOrderId, string $state) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->updateState([
                            "workOrderId" => $workOrderId,
                            "state" => $state,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\UpdateState\WorkOrder"
        );
    }

    /**
     * updateCategory
     *
     * @param  uint $workOrderId 工单ID [ require true ]
     * @param  string $category 分类 [ require true ]
     * @throws  \Exception
     * @return  UpdateCategory\WorkOrder
     */
    public static function updateCategory (int $workOrderId, string $category) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->updateCategory([
                            "workOrderId" => $workOrderId,
                            "category" => $category,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\UpdateCategory\WorkOrder"
        );
    }

    /**
     * bugChartByDate
     *
     * @support  string $createdAtStart 创建时间-起 require false
     * @support  string $createdAtEnd 创建时间-止 require false
     * @param  bool $isBug bug [ require true ]
     * @throws  \Exception
     * @return  BugChartByDate\DateCount[]
     */
    public static function bugChartByDate (bool $isBug = false) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->bugChartByDate([
                            "isBug" => $isBug,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\BugChartByDate\DateCount[]"
        );
    }

    /**
     * locationToCoding
     *
     * @param  uint $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function locationToCoding (int $workOrderId) {
        return self::getClass()->locationToCoding([
            "workOrderId" => $workOrderId,
        ]);
    }

    /**
     * resetDeletedCoding
     *
     * @support  string $createdAtStart 创建时间-起 require false
     * @support  string $createdAtEnd 创建时间-止 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetDeletedCoding () {
        return self::getClass()->resetDeletedCoding();
    }

    /**
     * getConnectSignature
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getConnectSignature () {
        return self::getClass()->getConnectSignature();
    }

    /**
     * send
     *
     * @support  App\Domain\WorkOrder\Vo\MessageContent $content  [ require true ]
     * @support  int $sender  [ require true ]
     * @support  int $workOrderId  [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function send (App\Domain\WorkOrder\Dto\SendDto $dto) {
        return self::getClass()->send([
            "dto" => $dto,
        ]);
    }

    /**
     * reply
     *
     * @support  App\Domain\WorkOrder\Vo\MessageContent $content  [ require true ]
     * @support  int $replier  [ require true ]
     * @support  int $workOrderId  [ require true ]
     * @throws  \Exception
     * @return  Reply\Message
     */
    public static function reply (App\Domain\WorkOrder\Dto\ReplyDto $dto) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->reply([
                            "dto" => $dto,
                        ]),
            "\Mainto\Bridge\Invokes\TechnicalUtils\Reply\Message"
        );
    }

    /**
     * historyMessages
     *
     * @support  int $workOrderId  [ require true ]
     * @support  int $beforeMessageId  require false
     * @support  int $limit  require false
     * @throws  \Exception
     * @return  array
     */
    public static function historyMessages (App\Domain\WorkOrder\Dto\HistoryMessageDto $dto) {
        return self::getClass()->historyMessages([
            "dto" => $dto,
        ]);
    }

    /**
     * connect
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function connect () {
        return self::getClass()->connect();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('TechnicalUtils', 'WorkOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('TechnicalUtils', 'WorkOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}