<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-10 14:16:29
 */
namespace Mainto\Bridge\Invokes\TechnicalUtils;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class WorkOrder
 */
class WorkOrder {
    private static string $serviceName = "TechnicalUtils";

    private static string $className = "WorkOrder";

    /**
     * 创建工单
     * @return  int
    */
    public static function create (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\CreateCommand $createCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createCommand);
    }
    /**
     * 管理员创建工单
     * @return  int
    */
    public static function createByAdmin (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\CreateByAdminCommand $createByAdminCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createByAdmin($createByAdminCommand);
    }
    /**
     * 删除工单
     * @return  bool
    */
    public static function delete (int $workOrderId, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["workOrderId" => $workOrderId, "operator" => $operator]);
    }
    /**
     * 获取上传签名
     * @return  string
    */
    public static function getUploadToken () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUploadToken();
    }
    /**
     * 查看工单详情
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO
    */
    public static function detail (int $workOrderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["workOrderId" => $workOrderId]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }
    /**
     * 获取工单数量
     * @return  int
    */
    public static function count () {
        return RpcClass::getClass(self::$serviceName, self::$className)->count();
    }
    /**
     * 获取回复数量
     * @return  int
    */
    public static function reporterCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->reporterCount();
    }
    /**
     * 获取未完结数量
     * @return  int
    */
    public static function notFinishedCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->notFinishedCount();
    }
    /**
     * 获取BUG数量
     * @return  int
    */
    public static function bugCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->bugCount();
    }
    /**
     * 获取关联Codeing信息
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\CodingInfoDTO
    */
    public static function codingInfo (int $workOrderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->codingInfo(["workOrderId" => $workOrderId]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\CodingInfoDTO"
        );
    }
    /**
     * 获取工单列表
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\ListDTO
    */
    public static function list (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\ListCommand $listCommand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($listCommand),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\ListDTO"
        );
    }
    /**
     * 处理工单
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO
    */
    public static function process (int $workOrderId, int $operator) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->process(["workOrderId" => $workOrderId, "operator" => $operator]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }
    /**
     * 完结工单
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO
    */
    public static function finish (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\FinishCommand $finishCommand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->finish($finishCommand),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }
    /**
     * 更新工单类别
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO
    */
    public static function updateCategory (int $workOrderId, string $category, int $operator) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->updateCategory(["workOrderId" => $workOrderId, "category" => $category, "operator" => $operator]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }
    /**
     * 统计类别的工单数量
     * @return  \Mainto\RpcServer\Util\Types\Map
    */
    public static function categoriesCount (string $createdAtStart, string $createdAtEnd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->categoriesCount(["createdAtStart" => $createdAtStart, "createdAtEnd" => $createdAtEnd]),
            "\Mainto\RpcServer\Util\Types\Map<string, \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\CategoryCountDTO>"
        );
    }
    /**
     * 
     * @return  array
    */
    public static function bugChartByDate (bool $isBug = false, string $createdAtStart, string $createdAtEnd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bugChartByDate(["isBug" => $isBug, "createdAtStart" => $createdAtStart, "createdAtEnd" => $createdAtEnd]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDateCountDTO[]"
        );
    }
    /**
     * 
     * @return  mixed
    */
    public static function locationToCoding (int $workOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->locationToCoding(["workOrderId" => $workOrderId]);
    }
    /**
     * createCoding
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO
    */
    public static function createCoding (int $workOrderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createCoding(["workOrderId" => $workOrderId]),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\WorkOrderDTO"
        );
    }
    /**
     * resetDeletedCoding
     * @return  mixed
    */
    public static function resetDeletedCoding (string $createdAtStart, string $createdAtEnd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resetDeletedCoding(["createdAtStart" => $createdAtStart, "createdAtEnd" => $createdAtEnd]);
    }
    /**
     * getConnectSignature
     * @return  array
    */
    public static function getConnectSignature () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getConnectSignature();
    }
    /**
     * send
     * @return  int
    */
    public static function send (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\SendCommand $sendCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->send($sendCommand);
    }
    /**
     * reply
     * @return  \Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\MessageDTO
    */
    public static function reply (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\ReplyCommand $replyCommand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->reply($replyCommand),
            "\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\DTO\MessageDTO"
        );
    }
    /**
     * historyMessages
     * @return  array
    */
    public static function historyMessages (\Mainto\Bridge\Structs\TechnicalUtils\WorkOrder\Http\Command\HistoryMessageCommand $historyMessageCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->historyMessages($historyMessageCommand);
    }
    /**
     * removeCodingRelation
     * @return  mixed
    */
    public static function removeCodingRelation (int $workOrderId, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeCodingRelation(["workOrderId" => $workOrderId, "operator" => $operator]);
    }
    /**
     * connect
     * @return  mixed
    */
    public static function connect () {
        return RpcClass::getClass(self::$serviceName, self::$className)->connect();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}