<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-07-27 09:44:26
 */
namespace Mainto\Bridge\Invokes\SupplyPlatform;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class StoreTagController
 * @method updatStoreTagsByParams(array $params) 修改门店分组
 * @method storeBatchBindStoreTagByParams(array $params) 门店绑定门店分组(最近7天新增用)
 * @method getStoreTagsPageListByParams(array $params) 门店分组列表
 * @method getStoreTagsListByParams(array $params) 门店分组列表(远程搜索)
 * @method storeTagBindStoreByParams(array $params) 门店分组绑定门店
 * @method deleteStoreTagsByParams(array $params) 删除门店分组
 * @method storeTagBatchBindStoreByParams(array $params) 门店分组批量绑定门店(批量)
 * @method storeBindStoreTagListByParams(array $params) 门店绑定的标签ids
 * @method createStoreTagsByParams(array $params) 创建门店分组
 * @method storeTagBindStoreListByParams(array $params) 门店分组绑定的门店ids
 */
class StoreTagController {
    private static string $serviceName = "SupplyPlatform";

    private static string $className = "StoreTagController";

    /**
     * 修改门店分组
     * @return  \Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Res\StoreTag\StoreTagsInfoRes
    */
    public static function updatStoreTags (?\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Req\StoreTag\StoreTagsUpdateReq $storeTagsUpdateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->updatStoreTags($storeTagsUpdateReq),
            "\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Res\StoreTag\StoreTagsInfoRes"
        );
    }

    /**
     * 门店绑定门店分组(最近7天新增用)
     * @return  bool
    */
    public static function storeBatchBindStoreTag (?\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Req\StoreTag\TagBindStoreListReq $tagBindStoreListReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeBatchBindStoreTag($tagBindStoreListReq);
    }

    /**
     * 门店分组列表
     * @return  \Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Res\StoreTag\StoreTagsPageListRes
    */
    public static function getStoreTagsPageList (?\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Req\StoreTag\StoreTagsPageListReq $storeTagsPageListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreTagsPageList($storeTagsPageListReq),
            "\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Res\StoreTag\StoreTagsPageListRes"
        );
    }

    /**
     * 门店分组列表(远程搜索)
     * @return  array
    */
    public static function getStoreTagsList (?\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Req\StoreTag\StoreTagsListReq $storeTagsListReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreTagsList($storeTagsListReq),
            "\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Res\StoreTag\StoreTagsInfoRes[]"
        );
    }

    /**
     * 门店分组绑定门店
     * @return  bool
    */
    public static function storeTagBindStore (?\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Req\StoreTag\TagBindStoreReq $tagBindStoreReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeTagBindStore($tagBindStoreReq);
    }

    /**
     * 删除门店分组
     * @return  bool
    */
    public static function deleteStoreTags (?\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Req\StoreTag\StoreTagsDelReq $storeTagsDelReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStoreTags($storeTagsDelReq);
    }

    /**
     * 门店分组批量绑定门店(批量)
     * @return  mixed
    */
    public static function storeTagBatchBindStore (?\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Req\StoreTag\TagBindStoreListReq $tagBindStoreListReq = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeTagBatchBindStore($tagBindStoreListReq);
    }

    /**
     * 门店绑定的标签ids
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Res\StoreTag\StoreHavaTagRes
    */
    public static function storeBindStoreTagList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->storeBindStoreTagList([]),
            "\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Res\StoreTag\StoreHavaTagRes"
        );
    }

    /**
     * 创建门店分组
     * @return  \Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Res\StoreTag\StoreTagsInfoRes
    */
    public static function createStoreTags (?\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Req\StoreTag\StoreTagsCreateReq $storeTagsCreateReq = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createStoreTags($storeTagsCreateReq),
            "\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Res\StoreTag\StoreTagsInfoRes"
        );
    }

    /**
     * 门店分组绑定的门店ids
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Res\StoreTag\TagBindStoreRes
    */
    public static function storeTagBindStoreList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->storeTagBindStoreList([]),
            "\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Tag\Model\Res\StoreTag\TagBindStoreRes"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}