<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-07-27 09:44:26
 */
namespace Mainto\Bridge\Invokes\SupplyPlatform;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductController
 * @method getLatestWeekStoreListByParams(array $params) 获取最近7天新添加的产品
 * @method getProductExportListByParams(array $params) 获取导出的产品And摄影标签(下载商品列表使用)
 * @method getProductAllListByParams(array $params) 获取所有的产品
 */
class ProductController {
    private static string $serviceName = "SupplyPlatform";

    private static string $className = "ProductController";

    /**
     * 获取最近7天新添加的产品
     * @return  array
    */
    public static function getLatestWeekStoreList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getLatestWeekStoreList(),
            "\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Product\Model\Res\ProductAllListRes[]"
        );
    }

    /**
     * 获取导出的产品And摄影标签(下载商品列表使用)
     * @return  array
    */
    public static function getProductExportList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductExportList(),
            "\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Product\Model\Res\ProductExportListRes[]"
        );
    }

    /**
     * 获取所有的产品
     * @return  array
    */
    public static function getProductAllList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductAllList(),
            "\Mainto\Bridge\Structs\SupplyPlatform\Com\Mainto\Supply\Application\Api\Product\Model\Res\ProductAllListRes[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}