<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-05-15 14:43:39
 */
namespace Mainto\Bridge\Invokes\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Area
 * @method getAllProvinceByParams(array $params) 获取所有省(包含直辖市)
 * @method getCityByParams(array $params) 获取城市
 * @method getAreaByParams(array $params) 获取区/县
 * @method getStreetByParams(array $params) 获取街道
 * @method getAreaTreeByParams(array $params) 获取省市区三级
 * @method getChildByParams(array $params) 获取子级
 * @method getParentByParams(array $params) 获取上一级父级
 * @method getParentsByParams(array $params) 获取所有父级
 * @method getFullNameByParams(array $params) 获取级联名称
 * @method setHotCityByParams(array $params) 设置为热门城市
 * @method unsetHotCityByParams(array $params) 取消设置为热门城市
 * @method getAreasByIdsByParams(array $params) 根据IDs查询地区信息
 * @method getAreasByIdsWithParentByParams(array $params) 根据IDs查询地区信息(带父级信息)
 */
class Area {
    private static string $serviceName = "Store";

    private static string $className = "Area";

    /**
     * 获取所有省(包含直辖市)
     * @return  mixed
    */
    public static function getAllProvince () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProvince();
    }

    /**
     * 获取城市
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getCity (int $provinceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCity(["provinceId" => $provinceId]);
    }

    /**
     * 获取区/县
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getArea (int $cityId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getArea(["cityId" => $cityId]);
    }

    /**
     * 获取街道
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStreet (int $areaId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreet(["areaId" => $areaId]);
    }

    /**
     * 获取省市区三级
     * @return  mixed
    */
    public static function getAreaTree () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAreaTree();
    }

    /**
     * 获取子级
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getChild (int $parentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getChild(["parentId" => $parentId]);
    }

    /**
     * 获取上一级父级
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getParent (int $childId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getParent(["childId" => $childId]);
    }

    /**
     * 获取所有父级
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getParents (int $childId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getParents(["childId" => $childId]);
    }

    /**
     * 获取级联名称
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getFullName (int $childId, string $joinStr = ' - ') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFullName(["childId" => $childId, "joinStr" => $joinStr]);
    }

    /**
     * 设置为热门城市
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function setHotCity (int $cityId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setHotCity(["cityId" => $cityId]);
    }

    /**
     * 取消设置为热门城市
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function unsetHotCity (int $cityId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unsetHotCity(["cityId" => $cityId]);
    }

    /**
     * 根据IDs查询地区信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAreasByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAreasByIds(["ids" => $ids]);
    }

    /**
     * 根据IDs查询地区信息(带父级信息)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAreasByIdsWithParent (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAreasByIdsWithParent(["ids" => $ids]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}