<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-24 10:27:01
 */
namespace Mainto\Bridge\Invokes\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Store
 * @method getHaveStoreCityByParams(array $params) 获得当前有门店的所有城市
 * @method searchStoreByDataByParams(array $params) 获取指定条件下的所有门店
 * @method getStoreAppointableTimeByParams(array $params) 根据门店id获取可预约时间点
 * @method getStoreInfoByIdsByParams(array $params) 根据门店id获取一组门店信息
 * @method getStoreOpenSortByParams(array $params) 根据门店id获取一组门店开业顺序信息
 * @method getStoreInfoByIdByParams(array $params) 根据门店id获取门店信息
 * @method getStoresByParams(array $params) 获取店铺列表(可进行搜索)
 * @method getStoresWithoutPageByParams(array $params) 获取店铺列表(可进行搜索)
 * @method getStoreInfoByNameByParams(array $params) 根据门店名称获取门店信息
 * @method updatePurchaseAddressByParams(array $params) 根据门店名称更新地址
 * @method getMaxStoreIdInAreaByParams(array $params) 获取指定区间内下一家店铺的ID
 * @method getAllStoreIdInAreaByParams(array $params) 获取指定区间内所有店铺的ID
 * @method createStoreByParams(array $params) 创建门店
 * @method editStoreByParams(array $params) 修改门店
 * @method editStoreStartBusinessByParams(array $params) 修改门店开业时间
 * @method editStoreServiceTimesByParams(array $params) 修改门店每时段服务数
 * @method editStoreServiceIntervalByParams(array $params) 修改门店每次服务间隔(分钟)
 * @method deleteStoreByParams(array $params) 删除门店
 * @method restoreStoreByParams(array $params) 恢复门店
 * @method getStoreIdByDianpingIdByParams(array $params) getStoreIdByDianpingId
 * @method getDianpingIdByStoreIdByParams(array $params) getDianpingIdByStoreId
 * @method getCityIdsByStoreIdsByParams(array $params) 根据门店组获取城市组
 * @method closeApplyByParams(array $params) 闭店申请
 * @method batchCloseOrOpenStoreByParams(array $params) 批量设置闭店/营业
 * @method batchGetStoreOperateLogByParams(array $params) 获取门店操作记录
 */
class Store {
    private static string $serviceName = "Store";

    private static string $className = "Store";

    /**
     * 获得当前有门店的所有城市
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getHaveStoreCity (array $store_type = [], bool $includeDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHaveStoreCity(["store_type" => $store_type, "includeDelete" => $includeDelete]);
    }

    /**
     * 获取指定条件下的所有门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function searchStoreByData (array $city_ids = [], array $store_type = [], string $type = 'base', bool $includeDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchStoreByData(["city_ids" => $city_ids, "store_type" => $store_type, "type" => $type, "includeDelete" => $includeDelete]);
    }

    /**
     * 根据门店id获取可预约时间点
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreAppointableTime (int $store_id, int $next_num, string $start_at = 'day', bool $return_all = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreAppointableTime(["store_id" => $store_id, "next_num" => $next_num, "start_at" => $start_at, "return_all" => $return_all]);
    }

    /**
     * 根据门店id获取一组门店信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreInfoByIds (array $store_ids, string $type = 'base', bool $includeDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreInfoByIds(["store_ids" => $store_ids, "type" => $type, "includeDelete" => $includeDelete]);
    }

    /**
     * 根据门店id获取一组门店开业顺序信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreOpenSort (array $store_ids, array $store_types) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreOpenSort(["store_ids" => $store_ids, "store_types" => $store_types]);
    }

    /**
     * 根据门店id获取门店信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreInfoById (int $store_id, string $type = 'base', bool $includeDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreInfoById(["store_id" => $store_id, "type" => $type, "includeDelete" => $includeDelete]);
    }

    /**
     * 获取店铺列表(可进行搜索)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStores (int $page = 1, bool $includeDelete = false, string $type = 'base') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStores(["page" => $page, "includeDelete" => $includeDelete, "type" => $type]);
    }

    /**
     * 获取店铺列表(可进行搜索)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoresWithoutPage (bool $includeDelete = false, string $type = 'base') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoresWithoutPage(["includeDelete" => $includeDelete, "type" => $type]);
    }

    /**
     * 根据门店名称获取门店信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreInfoByName (string $store_name, string $type = 'base') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreInfoByName(["store_name" => $store_name, "type" => $type]);
    }

    /**
     * 根据门店名称更新地址
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updatePurchaseAddress (string $storeName, string $address) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePurchaseAddress(["storeName" => $storeName, "address" => $address]);
    }

    /**
     * 获取指定区间内下一家店铺的ID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getMaxStoreIdInArea (int $areaMin, int $areaMax) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaxStoreIdInArea(["areaMin" => $areaMin, "areaMax" => $areaMax]);
    }

    /**
     * 获取指定区间内所有店铺的ID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAllStoreIdInArea (int $areaMin, int $areaMax) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStoreIdInArea(["areaMin" => $areaMin, "areaMax" => $areaMax]);
    }

    /**
     * 创建门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function createStore (int $storeId, int $cityId, int $provinceId, string $name, int $serviceInterval, int $serviceTimes, array $extend, int $sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStore(["storeId" => $storeId, "cityId" => $cityId, "provinceId" => $provinceId, "name" => $name, "serviceInterval" => $serviceInterval, "serviceTimes" => $serviceTimes, "extend" => $extend, "sort" => $sort]);
    }

    /**
     * 修改门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function editStore (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStore(["storeId" => $storeId]);
    }

    /**
     * 修改门店开业时间
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function editStoreStartBusiness (int $storeId, string $startBusiness) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStoreStartBusiness(["storeId" => $storeId, "startBusiness" => $startBusiness]);
    }

    /**
     * 修改门店每时段服务数
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function editStoreServiceTimes (int $storeId, int $changeTo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStoreServiceTimes(["storeId" => $storeId, "changeTo" => $changeTo]);
    }

    /**
     * 修改门店每次服务间隔(分钟)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function editStoreServiceInterval (int $storeId, int $newServiceInterval) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStoreServiceInterval(["storeId" => $storeId, "newServiceInterval" => $newServiceInterval]);
    }

    /**
     * 删除门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteStore (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStore(["storeId" => $storeId]);
    }

    /**
     * 恢复门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function restoreStore (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->restoreStore(["storeId" => $storeId]);
    }

    /**
     * getStoreIdByDianpingId
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreIdByDianpingId (string $dianpingId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdByDianpingId(["dianpingId" => $dianpingId]);
    }

    /**
     * getDianpingIdByStoreId
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getDianpingIdByStoreId (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDianpingIdByStoreId(["storeId" => $storeId]);
    }

    /**
     * 根据门店组获取城市组
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getCityIdsByStoreIds (array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCityIdsByStoreIds(["storeIds" => $storeIds]);
    }

    /**
     * 闭店申请
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function closeApply (int $storeId, string $closeStartAt, string $closeEndAt, string $closeReason, array $closeNotificationImg, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeApply(["storeId" => $storeId, "closeStartAt" => $closeStartAt, "closeEndAt" => $closeEndAt, "closeReason" => $closeReason, "closeNotificationImg" => $closeNotificationImg, "operator" => $operator]);
    }

    /**
     * 批量设置闭店/营业
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchCloseOrOpenStore (array $storeIds, bool $setClose, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCloseOrOpenStore(["storeIds" => $storeIds, "setClose" => $setClose, "operator" => $operator]);
    }

    /**
     * 获取门店操作记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchGetStoreOperateLog (array $storeIds = [], string $type = null, bool $includeDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetStoreOperateLog(["storeIds" => $storeIds, "type" => $type, "includeDelete" => $includeDelete]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}