<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-06-09 12:15:28
 */
namespace Mainto\Bridge\Invokes\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Classification
 */
class Classification {
    private static string $serviceName = "Store";

    private static string $className = "Classification";

    /**
     * 获取分类类型
     * @return  mixed
    */
    public static function getClassification () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getClassification();
    }
    /**
     * 获取分类列表
     * @return  mixed
    */
    public static function getClassificationList (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getClassificationList(["type" => $type]);
    }
    /**
     * 获取某分类详情
     * @return  mixed
    */
    public static function getClassificationInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getClassificationInfo(["id" => $id]);
    }
    /**
     * 获取某些分类下的列表
     * @return  mixed
    */
    public static function getClassificationStore (array $type_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getClassificationStore(["type_ids" => $type_ids]);
    }
    /**
     * 查找门店的所属分类
     * @return  mixed
    */
    public static function findStoreClassification (int $store_id, array $search_classification_types = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->findStoreClassification(["store_id" => $store_id, "search_classification_types" => $search_classification_types]);
    }
    /**
     * 查找门店组的所属分类
     * @return  mixed
    */
    public static function findStoreIdsClassification (array $storeIds, array $searchClassificationTypes = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->findStoreIdsClassification(["storeIds" => $storeIds, "searchClassificationTypes" => $searchClassificationTypes]);
    }
    /**
     * 创建门店分类
     * @return  mixed
    */
    public static function createClassification (string $type, string $name, int $num = -1, array $extend = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createClassification(["type" => $type, "name" => $name, "num" => $num, "extend" => $extend]);
    }
    /**
     * 修改门店分类
     * @return  mixed
    */
    public static function editClassification (int $id, string $name, array $extend = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editClassification(["id" => $id, "name" => $name, "extend" => $extend]);
    }
    /**
     * 将多家门店添加到分类中
     * @return  mixed
    */
    public static function addStoresToClassification (int $id, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStoresToClassification(["id" => $id, "storeIds" => $storeIds]);
    }
    /**
     * 将分类设置成某些门店
     * @return  mixed
    */
    public static function setStoresToClassification (int $id, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setStoresToClassification(["id" => $id, "storeIds" => $storeIds]);
    }
    /**
     * 从分类中移除多家门店
     * @return  mixed
    */
    public static function removeStoresToClassification (int $id, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeStoresToClassification(["id" => $id, "storeIds" => $storeIds]);
    }
    /**
     * hookChangeClassificationStore
     * @return  mixed
    */
    public static function hookChangeClassificationStore (int $classificationId, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookChangeClassificationStore(["classificationId" => $classificationId, "storeIds" => $storeIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}