<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-20 11:06:06
 */
namespace Mainto\Bridge\Invokes\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Store
 */
class Store {
    private static string $serviceName = "Store";

    private static string $className = "Store";

    /**
     * 获得当前有门店的所有城市
     * @return  mixed
    */
    public static function getHaveStoreCity (array $store_type = [], bool $includeDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHaveStoreCity(["store_type" => $store_type, "includeDelete" => $includeDelete]);
    }
    /**
     * 获取指定条件下的所有门店
     * @return  mixed
    */
    public static function searchStoreByData (array $city_ids = [], array $store_type = [], string $type = 'base', bool $includeDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchStoreByData(["city_ids" => $city_ids, "store_type" => $store_type, "type" => $type, "includeDelete" => $includeDelete]);
    }
    /**
     * 根据门店id获取可预约时间点
     * @return  mixed
    */
    public static function getStoreAppointableTime (int $store_id, int $next_num, string $start_at = 'day', bool $return_all = false, string $start_time) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreAppointableTime(["store_id" => $store_id, "next_num" => $next_num, "start_at" => $start_at, "return_all" => $return_all, "start_time" => $start_time]);
    }
    /**
     * 根据门店id获取一组门店信息
     * @return  mixed
    */
    public static function getStoreInfoByIds (array $store_ids, string $type = 'base', bool $includeDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreInfoByIds(["store_ids" => $store_ids, "type" => $type, "includeDelete" => $includeDelete]);
    }
    /**
     * 根据门店id获取一组门店开业顺序信息
     * @return  mixed
    */
    public static function getStoreOpenSort (array $store_ids, array $store_types) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreOpenSort(["store_ids" => $store_ids, "store_types" => $store_types]);
    }
    /**
     * 根据门店id获取门店信息
     * @return  mixed
    */
    public static function getStoreInfoById (int $store_id, string $type = 'base', bool $includeDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreInfoById(["store_id" => $store_id, "type" => $type, "includeDelete" => $includeDelete]);
    }
    /**
     * 获取店铺列表(可进行搜索)
     * @return  mixed
    */
    public static function getStores (int $page = 1, bool $includeDelete = false, string $type = 'base', string $status, string $name, int $groupId, int $provinceId, int $cityId, array $storeIds, string $affiliateType, array $storeTypes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStores(["page" => $page, "includeDelete" => $includeDelete, "type" => $type, "status" => $status, "name" => $name, "groupId" => $groupId, "provinceId" => $provinceId, "cityId" => $cityId, "storeIds" => $storeIds, "affiliateType" => $affiliateType, "storeTypes" => $storeTypes]);
    }
    /**
     * 获取店铺列表(可进行搜索)
     * @return  mixed
    */
    public static function getStoresWithoutPage (bool $includeDelete = false, string $type = 'base', array $provinceIds, array $cityIds, array $storeIds, array $affiliateTypes, array $storeTypes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoresWithoutPage(["includeDelete" => $includeDelete, "type" => $type, "provinceIds" => $provinceIds, "cityIds" => $cityIds, "storeIds" => $storeIds, "affiliateTypes" => $affiliateTypes, "storeTypes" => $storeTypes]);
    }
    /**
     * 根据门店名称获取门店信息
     * @return  mixed
    */
    public static function getStoreInfoByName (string $store_name, string $type = 'base') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreInfoByName(["store_name" => $store_name, "type" => $type]);
    }
    /**
     * 根据门店名称更新地址
     * @return  bool
    */
    public static function updatePurchaseAddress (string $storeName, string $address) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePurchaseAddress(["storeName" => $storeName, "address" => $address]);
    }
    /**
     * 获取指定区间内下一家店铺的ID
     * @return  mixed
    */
    public static function getMaxStoreIdInArea (int $areaMin, int $areaMax) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaxStoreIdInArea(["areaMin" => $areaMin, "areaMax" => $areaMax]);
    }
    /**
     * 获取指定区间内所有店铺的ID
     * @return  mixed
    */
    public static function getAllStoreIdInArea (int $areaMin, int $areaMax) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStoreIdInArea(["areaMin" => $areaMin, "areaMax" => $areaMax]);
    }
    /**
     * 创建门店
     * @return  mixed
    */
    public static function createStore (int $storeId, int $cityId, int $provinceId, int $groupId, string $affiliateType, string $storeType, string $name, string $startAppointmentTime, string $stopAppointmentTime, int $serviceInterval, int $serviceTimes, string $startBusiness, array $extend, string $dianpingId, int $sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStore(["storeId" => $storeId, "cityId" => $cityId, "provinceId" => $provinceId, "groupId" => $groupId, "affiliateType" => $affiliateType, "storeType" => $storeType, "name" => $name, "startAppointmentTime" => $startAppointmentTime, "stopAppointmentTime" => $stopAppointmentTime, "serviceInterval" => $serviceInterval, "serviceTimes" => $serviceTimes, "startBusiness" => $startBusiness, "extend" => $extend, "dianpingId" => $dianpingId, "sort" => $sort]);
    }
    /**
     * 修改门店
     * @return  mixed
    */
    public static function editStore (int $storeId, int $cityId, string $affiliateType, string $name, string $startAppointmentTime, string $stopAppointmentTime, array $extend, string $dianpingId, int $sort, string $usePosStatus, int $groupId, int $provinceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStore(["storeId" => $storeId, "cityId" => $cityId, "affiliateType" => $affiliateType, "name" => $name, "startAppointmentTime" => $startAppointmentTime, "stopAppointmentTime" => $stopAppointmentTime, "extend" => $extend, "dianpingId" => $dianpingId, "sort" => $sort, "usePosStatus" => $usePosStatus, "groupId" => $groupId, "provinceId" => $provinceId]);
    }
    /**
     * 修改门店开业时间
     * @return  mixed
    */
    public static function editStoreStartBusiness (int $storeId, string $startBusiness) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStoreStartBusiness(["storeId" => $storeId, "startBusiness" => $startBusiness]);
    }
    /**
     * 修改门店每时段服务数
     * @return  mixed
    */
    public static function editStoreServiceTimes (int $storeId, int $changeTo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStoreServiceTimes(["storeId" => $storeId, "changeTo" => $changeTo]);
    }
    /**
     * 修改门店每次服务间隔(分钟)
     * @return  mixed
    */
    public static function editStoreServiceInterval (int $storeId, int $newServiceInterval) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStoreServiceInterval(["storeId" => $storeId, "newServiceInterval" => $newServiceInterval]);
    }
    /**
     * 删除门店
     * @return  mixed
    */
    public static function deleteStore (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStore(["storeId" => $storeId]);
    }
    /**
     * 恢复门店
     * @return  mixed
    */
    public static function restoreStore (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->restoreStore(["storeId" => $storeId]);
    }
    /**
     * getStoreIdByDianpingId
     * @return  mixed
    */
    public static function getStoreIdByDianpingId (string $dianpingId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdByDianpingId(["dianpingId" => $dianpingId]);
    }
    /**
     * getDianpingIdByStoreId
     * @return  mixed
    */
    public static function getDianpingIdByStoreId (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDianpingIdByStoreId(["storeId" => $storeId]);
    }
    /**
     * 根据门店组获取城市组
     * @return  mixed
    */
    public static function getCityIdsByStoreIds (array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCityIdsByStoreIds(["storeIds" => $storeIds]);
    }
    /**
     * 闭店申请
     * @return  mixed
    */
    public static function closeApply (int $storeId, string $closeStartAt, string $closeEndAt, string $closeReason, array $closeNotificationImg, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeApply(["storeId" => $storeId, "closeStartAt" => $closeStartAt, "closeEndAt" => $closeEndAt, "closeReason" => $closeReason, "closeNotificationImg" => $closeNotificationImg, "operator" => $operator]);
    }
    /**
     * 批量设置闭店/营业
     * @return  mixed
    */
    public static function batchCloseOrOpenStore (array $storeIds, bool $setClose, int $operator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCloseOrOpenStore(["storeIds" => $storeIds, "setClose" => $setClose, "operator" => $operator]);
    }
    /**
     * 获取门店操作记录
     * @return  mixed
    */
    public static function batchGetStoreOperateLog (array $storeIds = [], string $type = null, bool $includeDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetStoreOperateLog(["storeIds" => $storeIds, "type" => $type, "includeDelete" => $includeDelete]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}