<?php
namespace Mainto\Bridge\Invokes\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getClassificationByParams(array $params)
 * @method getClassificationListByParams(array $params)
 * @method getClassificationInfoByParams(array $params)
 * @method getClassificationStoreByParams(array $params)
 * @method findStoreClassificationByParams(array $params)
 * @method createClassificationByParams(array $params)
 * @method editClassificationByParams(array $params)
 * @method addStoresToClassificationByParams(array $params)
 * @method setStoresToClassificationByParams(array $params)
 * @method removeStoresToClassificationByParams(array $params)
 */
class Classification {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取分类类型
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClassification () {
        return self::getClass()->getClassification();
    }

    /**
     * 获取分类列表
     *
     * @param  string $type 区域划分类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClassificationList (string $type) {
        return self::getClass()->getClassificationList([
            "type" => $type,
        ]);
    }

    /**
     * 获取某分类详情
     *
     * @param  uint $id 分类ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClassificationInfo (int $id) {
        return self::getClass()->getClassificationInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取某些分类下的列表
     *
     * @param  array $type_ids 分类ID数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClassificationStore (array $type_ids) {
        return self::getClass()->getClassificationStore([
            "type_ids" => $type_ids,
        ]);
    }

    /**
     * 查找门店的所属分类
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  array $search_classification_types 可寻找的类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function findStoreClassification (int $store_id, array $search_classification_types = []) {
        return self::getClass()->findStoreClassification([
            "store_id" => $store_id,
            "search_classification_types" => $search_classification_types,
        ]);
    }

    /**
     * 创建门店分类
     *
     * @param  string $type 分类类型 [ require true ]
     * @param  string $name 分类名称 [ require true ]
     * @param  int $num 分类ID [ require true ]
     * @param  array $extend 拓展信息(包含自动更新规则) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createClassification (string $type, string $name, int $num = -1, array $extend = []) {
        return self::getClass()->createClassification([
            "type" => $type,
            "name" => $name,
            "num" => $num,
            "extend" => $extend,
        ]);
    }

    /**
     * 修改门店分类
     *
     * @param  uint $id 分类ID [ require true ]
     * @param  string $name 分类名称 [ require true ]
     * @param  array $extend 拓展信息(包含自动更新规则) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editClassification (int $id, string $name, array $extend = []) {
        return self::getClass()->editClassification([
            "id" => $id,
            "name" => $name,
            "extend" => $extend,
        ]);
    }

    /**
     * 返回当前分类处理后剩余的门店
     *
     * @param  uint $id 分类ID [ require true ]
     * @param  array<uint> $storeIds 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStoresToClassification (int $id, array $storeIds) {
        return self::getClass()->addStoresToClassification([
            "id" => $id,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 返回当前分类处理后剩余的门店
     *
     * @param  uint $id 分类ID [ require true ]
     * @param  array<uint> $storeIds 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStoresToClassification (int $id, array $storeIds) {
        return self::getClass()->setStoresToClassification([
            "id" => $id,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 返回当前分类处理后剩余的门店
     *
     * @param  uint $id 分类ID [ require true ]
     * @param  array<uint> $storeIds 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStoresToClassification (int $id, array $storeIds) {
        return self::getClass()->removeStoresToClassification([
            "id" => $id,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Store', 'Classification');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Store', 'Classification');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}