<?php
namespace Mainto\Bridge\Invokes\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getGroupsByParams(array $params)
 */
class Group {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建集团
     *
     * @param  string $name 集团名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name) {
        return self::getClass()->create([
            "name" => $name,
        ]);
    }

    /**
     * 列表分页
     *
     * @param  string $name 集团名称 [ require true ]
     * @param  uint $page 页码 [ require true ]
     * @param  uint $pageSize 数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroups (string $name = '', int $page = 1, int $pageSize = 20) {
        return self::getClass()->getGroups([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Store', 'Group');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Store', 'Group');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}