<?php
namespace Mainto\Bridge\Invokes\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method editTagByParams(array $params)
 * @method getTagByParams(array $params)
 * @method getTagsByParams(array $params)
 * @method deleteTagByParams(array $params)
 */
class StoreTag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 增加或修改一个门店标记
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  string $tag 标记名称 [ require true ]
     * @param  mixed $content 标记内容 [ require true ]
     * @param  bool $withDelete 是否包含软删除 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function editTag (int $storeId, string $tag, mixed $content, bool $withDelete = false) {
        return self::getClass()->editTag([
            "storeId" => $storeId,
            "tag" => $tag,
            "content" => $content,
            "withDelete" => $withDelete,
        ]);
    }

    /**
     * 查询一个门店的指定标记
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  string $tag 标记名称 [ require true ]
     * @param  bool $withDelete 是否包含软删除 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTag (int $storeId, string $tag, bool $withDelete = false) {
        return self::getClass()->getTag([
            "storeId" => $storeId,
            "tag" => $tag,
            "withDelete" => $withDelete,
        ]);
    }

    /**
     * 查询一个门店的所有标记
     *
     * @param  array $storeIds 门店ID [ require true ]
     * @param  array $tags 标记类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTags (array $storeIds = [], array $tags = []) {
        return self::getClass()->getTags([
            "storeIds" => $storeIds,
            "tags" => $tags,
        ]);
    }

    /**
     * 删除一个门店的指定标记
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  string $tag 标记名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteTag (int $storeId, string $tag) {
        return self::getClass()->deleteTag([
            "storeId" => $storeId,
            "tag" => $tag,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Store', 'StoreTag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Store', 'StoreTag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}