<?php
namespace Mainto\Bridge\Invokes\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllProvinceByParams(array $params)
 * @method getCityByParams(array $params)
 * @method getAreaByParams(array $params)
 * @method getStreetByParams(array $params)
 * @method getChildByParams(array $params)
 * @method getParentByParams(array $params)
 * @method getParentsByParams(array $params)
 * @method getFullNameByParams(array $params)
 */
class Area {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有省(包含直辖市)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProvince () {
        return self::getClass()->getAllProvince();
    }

    /**
     * 获取城市
     *
     * @param  int $provinceId 上级省ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCity (int $provinceId) {
        return self::getClass()->getCity([
            "provinceId" => $provinceId,
        ]);
    }

    /**
     * 获取区/县
     *
     * @param  int $cityId 上级城市ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getArea (int $cityId) {
        return self::getClass()->getArea([
            "cityId" => $cityId,
        ]);
    }

    /**
     * 获取街道
     *
     * @param  int $areaId 上级区/县ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreet (int $areaId) {
        return self::getClass()->getStreet([
            "areaId" => $areaId,
        ]);
    }

    /**
     * 获取子级
     *
     * @param  int $parentId 要获取的父级ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getChild (int $parentId) {
        return self::getClass()->getChild([
            "parentId" => $parentId,
        ]);
    }

    /**
     * 获取上一级父级
     *
     * @param  int $childId 要获取的子级ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getParent (int $childId) {
        return self::getClass()->getParent([
            "childId" => $childId,
        ]);
    }

    /**
     * 获取所有父级
     *
     * @param  int $childId 要获取的子级ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getParents (int $childId) {
        return self::getClass()->getParents([
            "childId" => $childId,
        ]);
    }

    /**
     * 获取级联名称
     *
     * @param  int $childId 要获取的子级ID [Original type uint] [ require true ]
     * @param  string $joinStr 链接字符串 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFullName (int $childId, string $joinStr = ' - ') {
        return self::getClass()->getFullName([
            "childId" => $childId,
            "joinStr" => $joinStr,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Store', 'Area');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Store', 'Area');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}