<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-05-07 14:24:43
 */
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Anniversary
 * @method listByParams(array $params) 周年员工列表
 * @method exportByParams(array $params) 周年员工导出
 * @method staffAnniversaryNoticeByParams(array $params) 周年伙伴祝福推送
 * @method hrbpAnniversaryNoticeByParams(array $params) 周年HRBP消息推送
 * @method increaseAnniversaryByParams(array $params) 递增下一年纪念日
 * @method checkStaffAnniversaryPassByParams(array $params) 校验纪念日是否已过
 * @method getStaffAnniversaryHistoryByParams(array $params) 已庆祝过的纪念日
 * @method changeAdjustDayByParams(array $params) 更改用户的司龄校正天数
 * @method adjustStaffAnniversaryByParams(array $params) 手动更改伙伴的周年时间
 */
class Anniversary {
    private static string $serviceName = "Staff";

    private static string $className = "Anniversary";

    /**
     * 周年员工列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 15, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 周年员工导出
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function export (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->export($_params);
    }

    /**
     * 周年伙伴祝福推送
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function staffAnniversaryNotice (string $date = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffAnniversaryNotice(["date" => $date]);
    }

    /**
     * 周年HRBP消息推送
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hrbpAnniversaryNotice (int $day = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hrbpAnniversaryNotice(["day" => $day]);
    }

    /**
     * 递增下一年纪念日
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function increaseAnniversary (string $date = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->increaseAnniversary(["date" => $date]);
    }

    /**
     * 校验纪念日是否已过
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function checkStaffAnniversaryPass (int $staffId, int $serial) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkStaffAnniversaryPass(["staffId" => $staffId, "serial" => $serial]);
    }

    /**
     * 已庆祝过的纪念日
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStaffAnniversaryHistory (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffAnniversaryHistory(["staffId" => $staffId]);
    }

    /**
     * 更改用户的司龄校正天数
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function changeAdjustDay (int $staffId, int $adjustDay = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeAdjustDay(["staffId" => $staffId, "adjustDay" => $adjustDay]);
    }

    /**
     * 手动更改伙伴的周年时间
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function adjustStaffAnniversary (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->adjustStaffAnniversary($_params);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}