<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-04-02 16:12:17
 */
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ThirdPartyStaff
 * @method createByParams(array $params) 创建第三方员工数据
 * @method updateByParams(array $params) 更新第三方员工数据
 * @method deleteByParams(array $params) 批量删除第三方员工数据
 * @method getStaffsByParams(array $params) 批量获取第三方员工数据
 * @method getStaffListByParams(array $params) 批量获取第三方员工分页数据
 */
class ThirdPartyStaff {
    private static string $serviceName = "Staff";

    private static string $className = "ThirdPartyStaff";

    /**
     * 创建第三方员工数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }

    /**
     * 更新第三方员工数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function update (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update($_params);
    }

    /**
     * 批量删除第三方员工数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function delete (array $ids, string $originPlatform = 'other') {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["ids" => $ids, "originPlatform" => $originPlatform]);
    }

    /**
     * 批量获取第三方员工数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStaffs (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffs($_params);
    }

    /**
     * 批量获取第三方员工分页数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStaffList (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}