<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-20 16:54:49
 */
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ThirdPartyStaff
 */
class ThirdPartyStaff {
    private static string $serviceName = "Staff";

    private static string $className = "ThirdPartyStaff";

    /**
     * create
     * @return  array
    */
    public static function create (int $projectId, string $mobile, string $nickname, bool $needSync = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["projectId" => $projectId, "mobile" => $mobile, "nickname" => $nickname, "needSync" => $needSync]);
    }
    /**
     * update
     * @return  bool
    */
    public static function update (int $id, int $projectId = 0, string $mobile = '', string $nickname = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "projectId" => $projectId, "mobile" => $mobile, "nickname" => $nickname]);
    }
    /**
     * delete
     * @return  mixed
    */
    public static function delete (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["ids" => $ids]);
    }
    /**
     * getStaffs
     * @return  array
    */
    public static function getStaffs (array $ids, array $projectIds, string $mobile, string $nickname) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffs(["ids" => $ids, "projectIds" => $projectIds, "mobile" => $mobile, "nickname" => $nickname]);
    }
    /**
     * getStaffList
     * @return  array
    */
    public static function getStaffList (int $page = 1, int $pageSize = 10, array $projectIds, string $mobile, string $nickname) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffList(["page" => $page, "pageSize" => $pageSize, "projectIds" => $projectIds, "mobile" => $mobile, "nickname" => $nickname]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}