<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-20 17:03:18
 */
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 */
class Staff {
    private static string $serviceName = "Staff";

    private static string $className = "Staff";

    /**
     * [分页]通过部门获取伙伴列表
     * @return  array
    */
    public static function getStaffListByDept (int $dept = 0, int $position = null, int $count = 10, int $page = 1, array $staff_ids = [], int $state = 1, string $level = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffListByDept(["dept" => $dept, "position" => $position, "count" => $count, "page" => $page, "staff_ids" => $staff_ids, "state" => $state, "level" => $level]);
    }
    /**
     * 根据批量职位id获取员工列表
     * @return  mixed
    */
    public static function getStaffListByJobs (array $job_ids, bool $with_staff = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffListByJobs(["job_ids" => $job_ids, "with_staff" => $with_staff]);
    }
    /**
     * 根据job获取伙伴数量
     * @return  array
    */
    public static function getStaffCountByJobs (array $jobIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffCountByJobs(["jobIds" => $jobIds]);
    }
    /**
     * 根据批量部门id获取员工列表
     * @return  array
    */
    public static function getStaffListByDepts (array $depts, bool $withChild = false, bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffListByDepts(["depts" => $depts, "withChild" => $withChild, "withDel" => $withDel]);
    }
    /**
     * [分页]通过门店获取伙伴列表
     * @return  mixed
    */
    public static function getStaffListByStore (int $store, int $position = null, int $count = 10, int $page = 1, array $staff_ids = [], int $state = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffListByStore(["store" => $store, "position" => $position, "count" => $count, "page" => $page, "staff_ids" => $staff_ids, "state" => $state]);
    }
    /**
     * 获取某个门店所有伙伴
     * @return  array
    */
    public static function getAllStaffsByStore (int $storeId, string $staffType, bool $withOutsider = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStaffsByStore(["storeId" => $storeId, "staffType" => $staffType, "withOutsider" => $withOutsider]);
    }
    /**
     * 通过伙伴ID获取单个伙伴信息
     * @return  array
    */
    public static function getStaffById (int $staffId, int $includDelete = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffById(["staffId" => $staffId, "includDelete" => $includDelete]);
    }
    /**
     * [批量] 根据伙伴id查询伙伴信息
     * @return  array
    */
    public static function getStaffByBatch (array $staff_ids, bool $with_delete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffByBatch(["staff_ids" => $staff_ids, "with_delete" => $with_delete]);
    }
    /**
     * 查询伙伴Ids
     * @return  array
    */
    public static function getStaffIds (array $deptIds, string $name, string $nickname, string $nameOrNickname, bool $withDel, bool $onlyDel, array $staffIds, array $positionIds, array $dingdingUids, string $level, array $storeIds, string $phone, string $entryTimeStart, string $entryTimeEnd, array $orderBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffIds(["deptIds" => $deptIds, "name" => $name, "nickname" => $nickname, "nameOrNickname" => $nameOrNickname, "withDel" => $withDel, "onlyDel" => $onlyDel, "staffIds" => $staffIds, "positionIds" => $positionIds, "dingdingUids" => $dingdingUids, "level" => $level, "storeIds" => $storeIds, "phone" => $phone, "entryTimeStart" => $entryTimeStart, "entryTimeEnd" => $entryTimeEnd, "orderBy" => $orderBy]);
    }
    /**
     * 获取员工s
     * @return  array
    */
    public static function getStaffColumns (array $columns, array $deptIds, string $name, string $nickname, string $nameOrNickname, bool $withDel, bool $onlyDel, array $staffIds, array $positionIds, array $dingdingUids, string $level, array $storeIds, string $phone, string $entryTimeStart, string $entryTimeEnd, array $orderBy, bool $withOutsider = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffColumns(["columns" => $columns, "deptIds" => $deptIds, "name" => $name, "nickname" => $nickname, "nameOrNickname" => $nameOrNickname, "withDel" => $withDel, "onlyDel" => $onlyDel, "staffIds" => $staffIds, "positionIds" => $positionIds, "dingdingUids" => $dingdingUids, "level" => $level, "storeIds" => $storeIds, "phone" => $phone, "entryTimeStart" => $entryTimeStart, "entryTimeEnd" => $entryTimeEnd, "orderBy" => $orderBy, "withOutsider" => $withOutsider]);
    }
    /**
     * 获取业绩员工信息
     * @return  array
    */
    public static function getStaffsWithStoreIdAndAvatar (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffsWithStoreIdAndAvatar(["staffIds" => $staffIds]);
    }
    /**
     * 获取员工列表[分页]
     * @return  array
    */
    public static function getStaffListByColumns (array $columns, int $page = 1, int $pageSize = 10, array $deptIds, string $deptPath, string $name, string $nickname, string $nameOrNickname, bool $withDel, bool $onlyDel, array $staffIds, array $positionIds, array $dingdingUids, string $level, array $storeIds, string $phone, string $entryTimeStart, string $entryTimeEnd, array $orderBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffListByColumns(["columns" => $columns, "page" => $page, "pageSize" => $pageSize, "deptIds" => $deptIds, "deptPath" => $deptPath, "name" => $name, "nickname" => $nickname, "nameOrNickname" => $nameOrNickname, "withDel" => $withDel, "onlyDel" => $onlyDel, "staffIds" => $staffIds, "positionIds" => $positionIds, "dingdingUids" => $dingdingUids, "level" => $level, "storeIds" => $storeIds, "phone" => $phone, "entryTimeStart" => $entryTimeStart, "entryTimeEnd" => $entryTimeEnd, "orderBy" => $orderBy]);
    }
    /**
     * 查询伙伴列表
     * @return  array
    */
    public static function getStaff (array $deptIds = [], array $positionIds = [], array $storeId = [], array $staffIds = [], string $level = '', string $name = '', string $nickname = '', bool $withDel = false, array $exceptStaffIds = [], bool $onlyDel = false, string $phone = '', string $entryStartTime = '', string $entryEndTime = '', int $page = 1, int $pageSize = 15, bool $isAll = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaff(["deptIds" => $deptIds, "positionIds" => $positionIds, "storeId" => $storeId, "staffIds" => $staffIds, "level" => $level, "name" => $name, "nickname" => $nickname, "withDel" => $withDel, "exceptStaffIds" => $exceptStaffIds, "onlyDel" => $onlyDel, "phone" => $phone, "entryStartTime" => $entryStartTime, "entryEndTime" => $entryEndTime, "page" => $page, "pageSize" => $pageSize, "isAll" => $isAll]);
    }
    /**
     * 查询指定伙伴信息[根据id倒序 分页]
     * @return  array
    */
    public static function getColumnsByIdsAndDeptIds (array $columns, array $deptIds = [], array $staffIds = [], bool $withDel = false, int $page = 1, int $pageSize = 15, bool $isAll = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getColumnsByIdsAndDeptIds(["columns" => $columns, "deptIds" => $deptIds, "staffIds" => $staffIds, "withDel" => $withDel, "page" => $page, "pageSize" => $pageSize, "isAll" => $isAll]);
    }
    /**
     * 通过多个伙伴ID获取伙伴姓名
     * @return  array
    */
    public static function getStaffNameByIds (array $staffIds, bool $withDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffNameByIds(["staffIds" => $staffIds, "withDelete" => $withDelete]);
    }
    /**
     * 通过伙伴姓名获得可能的工号
     * @return  array
    */
    public static function getStaffIdsByRealName (string $staffName, bool $isLike = false, bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffIdsByRealName(["staffName" => $staffName, "isLike" => $isLike, "withDel" => $withDel]);
    }
    /**
     * 通过伙伴姓名或花名获得可能的工号
     * @return  array
    */
    public static function getStaffIdsByRealOrNickName (string $staffName, bool $isLike = false, bool $getAll = false, bool $withDel = false, bool $withOutsider = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffIdsByRealOrNickName(["staffName" => $staffName, "isLike" => $isLike, "getAll" => $getAll, "withDel" => $withDel, "withOutsider" => $withOutsider]);
    }
    /**
     * 通过伙伴花名获得可能的工号
     * @return  array
    */
    public static function getStaffIdsByNickName (string $staffName, bool $isLike = false, bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffIdsByNickName(["staffName" => $staffName, "isLike" => $isLike, "withDel" => $withDel]);
    }
    /**
     * 通过多个伙伴ID获取伙伴姓名
     * @return  array
    */
    public static function getStaffInfoByIds (array $staffIds, bool $withDel = false, string $includeLeaveDate = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffInfoByIds(["staffIds" => $staffIds, "withDel" => $withDel, "includeLeaveDate" => $includeLeaveDate]);
    }
    /**
     * 根据staff_id 换区dingding uid
     * @return  array
    */
    public static function getDingdingUid (array $staff_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDingdingUid(["staff_ids" => $staff_ids]);
    }
    /**
     * 新增伙伴（自动创建主键，主键现由北森统一维护
     * @return  array
    */
    public static function addStaffWithAutoIncrement (int $id, string $name, int $jobId, string $level, string $phone, string $entryAt, array $departmentIds, string $nickname, string $proTitle) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStaffWithAutoIncrement(["id" => $id, "name" => $name, "jobId" => $jobId, "level" => $level, "phone" => $phone, "entryAt" => $entryAt, "departmentIds" => $departmentIds, "nickname" => $nickname, "proTitle" => $proTitle]);
    }
    /**
     * 修改伙伴信息
     * @return  bool
    */
    public static function updateStaff (int $id, string $name, string $level, string $phone, int $jobId, string $entryAt, string $nickname, string $proTitle, string $dingdingUid, array $departmentIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStaff(["id" => $id, "name" => $name, "level" => $level, "phone" => $phone, "jobId" => $jobId, "entryAt" => $entryAt, "nickname" => $nickname, "proTitle" => $proTitle, "dingdingUid" => $dingdingUid, "departmentIds" => $departmentIds]);
    }
    /**
     * 使用钉钉回调通知更新伙伴信息
     * @return  bool
    */
    public static function updateStaffByDingTalkReq () {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStaffByDingTalkReq();
    }
    /**
     * 完善添加钉钉用户异常数据（开启隐私保护的）
     * @return  bool
    */
    public static function completeExceptionDingTalkCreateStaff () {
        return RpcClass::getClass(self::$serviceName, self::$className)->completeExceptionDingTalkCreateStaff();
    }
    /**
     * 强制删除伙伴
     * @return  bool
    */
    public static function forceRemoveStaff (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->forceRemoveStaff(["staffId" => $staffId]);
    }
    /**
     * 修改伙伴信息
     * @return  mixed
    */
    public static function editStaffInfo (int $id, string $phone = '', string $name = '', string $dingding_uid = '', int $department_id = 0, int $level = null, int $job_id = 0, string $entry_at = '', string $pro_title = '', string $nickname) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStaffInfo(["id" => $id, "phone" => $phone, "name" => $name, "dingding_uid" => $dingding_uid, "department_id" => $department_id, "level" => $level, "job_id" => $job_id, "entry_at" => $entry_at, "pro_title" => $pro_title, "nickname" => $nickname]);
    }
    /**
     * 伙伴离职
     * @return  bool
    */
    public static function staffResignation (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffResignation(["id" => $id]);
    }
    /**
     * 伙伴复职
     * @return  bool
    */
    public static function staffUnResignation (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffUnResignation(["id" => $id]);
    }
    /**
     * 根据管理店铺获取员工信息
     * @return  array
    */
    public static function getStaffListByManageStore (int $store, int $page = 1, int $count = 10, bool $withDelete = false, bool $withDeptStore = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffListByManageStore(["store" => $store, "page" => $page, "count" => $count, "withDelete" => $withDelete, "withDeptStore" => $withDeptStore]);
    }
    /**
     * 根据伙伴钉钉Id获取伙伴上级列表
     * @return  array
    */
    public static function queryDeptManagerByStaff (string $dingTalkId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryDeptManagerByStaff(["dingTalkId" => $dingTalkId]);
    }
    /**
     * 获取伙伴所有上级部门
     * @return  array
    */
    public static function getStaffAllDepParent (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffAllDepParent(["staffId" => $staffId]);
    }
    /**
     * 根据钉钉uid获取伙伴信息
     * @return  mixed
    */
    public static function getStaffDetailByDingId (string $dingId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffDetailByDingId(["dingId" => $dingId]);
    }
    /**
     * 创建兼岗
     * @return  bool
    */
    public static function createStaffPluralism (int $staffId, int $storeId, int $jobId, int $operatorId, int $status = 1, string $startTime = '', string $endTime = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStaffPluralism(["staffId" => $staffId, "storeId" => $storeId, "jobId" => $jobId, "operatorId" => $operatorId, "status" => $status, "startTime" => $startTime, "endTime" => $endTime]);
    }
    /**
     * 自动确认正在兼岗
     * @return  bool
    */
    public static function autoPendingStaffPluralism () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoPendingStaffPluralism();
    }
    /**
     * 自动中止到期兼岗
     * @return  bool
    */
    public static function autoStopStaffPluralism () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoStopStaffPluralism();
    }
    /**
     * 操作兼岗请求
     * @return  bool
    */
    public static function handleStaffPluralism (int $pluralismId, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleStaffPluralism(["pluralismId" => $pluralismId, "type" => $type]);
    }
    /**
     * 删除某伙伴所有兼岗信息
     * @return  bool
    */
    public static function removeStaffAllPluralism (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeStaffAllPluralism(["staffId" => $staffId]);
    }
    /**
     * 兼岗列表
     * @return  array
    */
    public static function staffPluralismList (bool $withDel = false, int $page = 1, int $pageSize = 15, array $deptIds, array $pluralismStoreId, int $jobId, array $status, array $staffIds, string $name, array $sortFields) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffPluralismList(["withDel" => $withDel, "page" => $page, "pageSize" => $pageSize, "deptIds" => $deptIds, "pluralismStoreId" => $pluralismStoreId, "jobId" => $jobId, "status" => $status, "staffIds" => $staffIds, "name" => $name, "sortFields" => $sortFields]);
    }
    /**
     * 获取兼岗
     * @return  array
    */
    public static function getStaffPluralism (bool $withDel = false, array $deptIds, array $pluralismStoreId, array $jobIds, array $status, array $staffIds, string $name, array $sortFields) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffPluralism(["withDel" => $withDel, "deptIds" => $deptIds, "pluralismStoreId" => $pluralismStoreId, "jobIds" => $jobIds, "status" => $status, "staffIds" => $staffIds, "name" => $name, "sortFields" => $sortFields]);
    }
    /**
     * 撤销兼岗
     * @return  bool
    */
    public static function cancelPluralism (int $staffId, int $storeId, int $jobId, int $operatorId, string $startTime, string $endTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelPluralism(["staffId" => $staffId, "storeId" => $storeId, "jobId" => $jobId, "operatorId" => $operatorId, "startTime" => $startTime, "endTime" => $endTime]);
    }
    /**
     * 统计兼岗状态数量
     * @return  array
    */
    public static function countPluralismNum (array $deptIds = [], array $pluralismStoreIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->countPluralismNum(["deptIds" => $deptIds, "pluralismStoreIds" => $pluralismStoreIds]);
    }
    /**
     * 获取兼岗详情
     * @return  mixed
    */
    public static function getStaffPluralismDetail (int $pluralismId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffPluralismDetail(["pluralismId" => $pluralismId]);
    }
    /**
     * 获取伙伴所有部门信息
     * @return  array
    */
    public static function getStaffAllDepartmentByStaffId (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffAllDepartmentByStaffId(["staffId" => $staffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}