<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-30 12:00:51
 */
namespace Mainto\Bridge\Invokes\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Department
 */
class Department {
    private static string $serviceName = "Staff";

    private static string $className = "Department";

    /**
     * 新增部门
     * @return  array
    */
    public static function createDepartment (int $id, int $parent, int $store_id, string $name, int $subjectId, int $costType, int $depType = 0, int $hrbp = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createDepartment(["id" => $id, "parent" => $parent, "store_id" => $store_id, "name" => $name, "subjectId" => $subjectId, "costType" => $costType, "depType" => $depType, "hrbp" => $hrbp]);
    }
    /**
     * 修改架构
     * @return  array
    */
    public static function editDepartment (int $id, string $name, int $store_id, int $parent, int $dep_type, int $dingManagerStaffId, int $subjectId, int $costType, int $hrbp) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editDepartment(["id" => $id, "name" => $name, "store_id" => $store_id, "parent" => $parent, "dep_type" => $dep_type, "dingManagerStaffId" => $dingManagerStaffId, "subjectId" => $subjectId, "costType" => $costType, "hrbp" => $hrbp]);
    }
    /**
     * 删除架构
     * @return  bool
    */
    public static function delDepartment (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delDepartment(["id" => $id]);
    }
    /**
     * 创建部门分类
     * @return  bool
    */
    public static function createDepType (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createDepType(["name" => $name]);
    }
    /**
     * 删除分类名称
     * @return  bool
    */
    public static function delDepType (int $depTypeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delDepType(["depTypeId" => $depTypeId]);
    }
    /**
     * 修改分类名称
     * @return  bool
    */
    public static function editDepType (int $depTypeId, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editDepType(["depTypeId" => $depTypeId, "name" => $name]);
    }
    /**
     * 查找分类名称
     * @return  mixed
    */
    public static function getDepType (array $depTypeIds = [], string $name = '', bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepType(["depTypeIds" => $depTypeIds, "name" => $name, "withDel" => $withDel]);
    }
    /**
     * 新增职位
     * @return  array
    */
    public static function addPosition (int $id, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addPosition(["id" => $id, "name" => $name]);
    }
    /**
     * 新增职位
     * @return  array
    */
    public static function createPosition (int $id, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPosition(["id" => $id, "name" => $name]);
    }
    /**
     * 修改职位名称
     * @return  bool
    */
    public static function editPositionName (int $id, string $name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->editPositionName(["id" => $id, "name" => $name]);
    }
    /**
     * 删除职位
     * @return  bool
    */
    public static function delPosition (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delPosition(["id" => $id]);
    }
    /**
     * 根据部门ID获取部门详情
     * @return  array
    */
    public static function getDepartmentDetail (array $deptIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentDetail(["deptIds" => $deptIds]);
    }
    /**
     * 根据部门分类id获取部门详情
     * @return  array
    */
    public static function getDepartmentByType (int $typeId, bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentByType(["typeId" => $typeId, "withDel" => $withDel]);
    }
    /**
     * 根据职位ID获取职位详情
     * @return  array
    */
    public static function getPositionDetail (array $positionIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPositionDetail(["positionIds" => $positionIds]);
    }
    /**
     * 转换区域名称
     * @return  array
    */
    public static function getAreaTranslate (array $deptIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAreaTranslate(["deptIds" => $deptIds]);
    }
    /**
     * 根据部门ID获取店铺ID
     * @return  mixed
    */
    public static function getStoreByDeptId (int $deptId, bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreByDeptId(["deptId" => $deptId, "withDel" => $withDel]);
    }
    /**
     * 根据门店ids获取部门
     * @return  mixed
    */
    public static function getDepartmentByStoreIds (array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentByStoreIds(["storeIds" => $storeIds]);
    }
    /**
     * 获取部门列表
     * @return  mixed
    */
    public static function getDepartment (string $name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartment(["name" => $name]);
    }
    /**
     * 获取部门列表，支持名称模糊搜索
     * @return  array
    */
    public static function getDepartmentsByName (string $name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartmentsByName(["name" => $name]);
    }
    /**
     * 获取部门所有关系部门
     * @return  mixed
    */
    public static function getFamilyDepartment (int $deptId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFamilyDepartment(["deptId" => $deptId]);
    }
    /**
     * 获取岗位列表 (模糊查询匹配模式调用方自己处理)
     * @return  mixed
    */
    public static function getPosition (string $name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPosition(["name" => $name]);
    }
    /**
     * 按父级id和level搜索信息
     * @return  array
    */
    public static function searchByLevel (int $level = null, int $parent_id = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchByLevel(["level" => $level, "parent_id" => $parent_id]);
    }
    /**
     * 处理钉钉部门修改
     * @return  mixed
    */
    public static function onDingDepartmentUpdate (array $DeptId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onDingDepartmentUpdate(["DeptId" => $DeptId]);
    }
    /**
     * 部门树
     * @return  array
    */
    public static function departmentTree (bool $withDel = false, int $beginDepartmentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->departmentTree(["withDel" => $withDel, "beginDepartmentId" => $beginDepartmentId]);
    }
    /**
     * 根据部门id获取所有子部门和本身
     * @return  array
    */
    public static function childDepartments (array $deptIds, array $fields, bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->childDepartments(["deptIds" => $deptIds, "fields" => $fields, "withDel" => $withDel]);
    }
    /**
     * 所有部门
     * @return  array
    */
    public static function getDepartments (bool $withDel = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDepartments(["withDel" => $withDel]);
    }
    /**
     * 同步部门主体
     * @return  bool
    */
    public static function syncSubjects (array $subjects) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncSubjects(["subjects" => $subjects]);
    }
    /**
     * 获取所有的主体
     * @return  array
    */
    public static function getSubjects () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubjects();
    }
    /**
     * 根据主体获取部门信息
     * @return  array
    */
    public static function getStoreIdsBySubjectId (int $subjectId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsBySubjectId(["subjectId" => $subjectId]);
    }
    /**
     * 根据部门ids获取父级信息
     * @return  array
    */
    public static function getDetailWithParentInfo (array $departmentIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDetailWithParentInfo(["departmentIds" => $departmentIds]);
    }
    /**
     * 通过门店ID获取店长s
     * @return  array
    */
    public static function getShopManagersByStoreId (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShopManagersByStoreId(["storeId" => $storeId]);
    }
    /**
     * 通过部门ID获取部门下店长s
     * @return  array
    */
    public static function getShopManagersByArea (int $departmentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShopManagersByArea(["departmentId" => $departmentId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}